/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.activation.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Hashtable;
import java.util.Map;
import org.apache.avalon.activation.ApplianceException;
import org.apache.avalon.activation.impl.DefaultBlock;
import org.apache.avalon.composition.model.ContainmentModel;
import org.apache.avalon.composition.model.DeploymentModel;
import org.apache.avalon.composition.model.Reclaimer;
import org.apache.avalon.composition.model.ServiceModel;
import org.apache.avalon.framework.logger.Logger;

final class BlockInvocationHandler
implements InvocationHandler {
    private final DefaultBlock m_block;
    private final Logger m_logger;
    private final Map m_providers = new Hashtable();

    protected BlockInvocationHandler(Logger logger, DefaultBlock block) throws Exception {
        if (block == null) {
            throw new NullPointerException("block");
        }
        this.m_block = block;
        this.m_logger = logger;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> source;
        if (proxy == null) {
            throw new NullPointerException("proxy");
        }
        if (method == null) {
            throw new NullPointerException("method");
        }
        ContainmentModel model = this.m_block.getContainmentModel();
        ServiceModel service = model.getServiceModel(source = method.getDeclaringClass());
        if (null == service) {
            String error = "Unable to resolve an provider for the class [" + source.getName() + "].";
            throw new IllegalStateException(error);
        }
        DeploymentModel provider = service.getServiceProvider();
        try {
            Object object = this.locateServiceInstance(provider);
            return method.invoke(object, args);
        }
        catch (UndeclaredThrowableException e) {
            Throwable cause = e.getUndeclaredThrowable();
            if (cause != null) {
                throw cause;
            }
            String error = "Delegation error raised by: " + this.m_block;
            throw new ApplianceException(error, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            if (cause != null) {
                throw cause;
            }
            String error = "Delegation error raised by: " + this.m_block;
            throw new ApplianceException(error, (Throwable)e);
        }
        catch (Throwable e) {
            String error = "Composite service resolution failure for the class: '" + method.getDeclaringClass() + "' for operation: '" + method.getName() + "' in appliance: " + this.m_block;
            throw new ApplianceException(error, e);
        }
    }

    private Object locateServiceInstance(DeploymentModel provider) throws Exception {
        Object source = this.m_providers.get(provider);
        if (null != source) {
            return source;
        }
        Object object = provider.resolve();
        this.m_providers.put(provider, object);
        return object;
    }

    protected void finalize() throws Throwable {
        Object[] objects = this.m_providers.values().toArray();
        for (int i = 0; i < objects.length; ++i) {
            InvocationHandler handler;
            Object instance = objects[i];
            if (!Proxy.isProxyClass(instance.getClass()) || !((handler = Proxy.getInvocationHandler(instance)) instanceof Reclaimer)) continue;
            Reclaimer source = (Reclaimer)handler;
            source.release();
        }
        this.m_providers.clear();
    }
}

