/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.activation.impl;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.apache.avalon.activation.ComponentFactory;
import org.apache.avalon.activation.impl.AbstractLifestyleManager;
import org.apache.avalon.composition.model.ComponentModel;

public class TransientLifestyleManager
extends AbstractLifestyleManager {
    private ArrayList m_list = new ArrayList();

    public TransientLifestyleManager(ComponentModel model, ComponentFactory factory) {
        super(model, factory);
    }

    public void commission() throws Exception {
        if (this.getComponentModel().getActivationPolicy()) {
            this.handleResolve();
        }
    }

    public void decommission() {
        Reference[] refs = this.m_list.toArray(new Reference[0]);
        for (int i = 0; i < refs.length; ++i) {
            Reference ref = refs[i];
            this.finalize(refs[i].get());
        }
        this.m_list.clear();
    }

    protected Object handleResolve() throws Exception {
        Object instance = this.getComponentFactory().incarnate();
        Reference reference = this.getReference(instance);
        this.m_list.add(reference);
        return instance;
    }

    protected void handleRelease(Object instance) {
        this.finalize(instance);
    }

    protected Reference getReference(Object instance) {
        int policy = this.getComponentModel().getCollectionPolicy();
        if (policy == 1) {
            return new SoftReference<Object>(instance);
        }
        return new WeakReference<Object>(instance, this.getLiberalQueue());
    }
}

