/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.activation.impl;

import org.apache.avalon.activation.ComponentFactory;
import org.apache.avalon.activation.LifestyleRuntimeException;
import org.apache.avalon.activation.impl.AbstractLifestyleManager;
import org.apache.avalon.composition.model.ComponentModel;

public class ThreadLifestyleManager
extends AbstractLifestyleManager {
    private ThreadLocalHolder m_local;

    public ThreadLifestyleManager(ComponentModel model, ComponentFactory factory) {
        super(model, factory);
    }

    public void commission() throws Exception {
        if (this.getComponentModel().getActivationPolicy()) {
            this.resolve();
        }
    }

    public synchronized void decommission() {
        if (this.m_local != null) {
            this.finalize(this.m_local.get());
            this.m_local = null;
        }
    }

    protected Object handleResolve() throws Exception {
        if (this.m_local == null) {
            ComponentFactory factory = this.getComponentFactory();
            this.m_local = new ThreadLocalHolder(factory);
        }
        return this.m_local.get();
    }

    protected void handleRelease(Object instance) {
    }

    private static final class ThreadLocalHolder
    extends ThreadLocal {
        private final ComponentFactory m_factory;

        protected ThreadLocalHolder(ComponentFactory factory) {
            this.m_factory = factory;
        }

        protected Object initialValue() {
            try {
                return this.m_factory.incarnate();
            }
            catch (Exception e) {
                String error = "Unable to establish thread local variable.";
                throw new LifestyleRuntimeException("Unable to establish thread local variable.", (Throwable)e);
            }
        }
    }
}

