/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.activation.lifestyle.impl;

import java.lang.ref.Reference;
import org.apache.avalon.activation.lifecycle.Factory;
import org.apache.avalon.activation.lifestyle.impl.AbstractLifestyleHandler;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.logger.Logger;

public class SingletonLifestyleHandler
extends AbstractLifestyleHandler
implements Disposable {
    private Reference m_reference;

    public SingletonLifestyleHandler(Logger logger, Factory factory) {
        super(logger, factory);
        if (factory == null) {
            throw new IllegalStateException("factory");
        }
    }

    public synchronized Object resolve() throws Exception {
        Object instance = null;
        if (this.m_reference == null) {
            return this.refreshReference();
        }
        instance = this.m_reference.get();
        if (instance == null) {
            return this.refreshReference();
        }
        return instance;
    }

    public synchronized void release(Object instance, boolean finalized) {
        if (finalized) {
            this.m_reference = null;
        }
    }

    public void dispose() {
        if (this.m_reference != null) {
            this.disposeInstance(this.m_reference.get());
            this.m_reference = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object refreshReference() throws Exception {
        Factory factory = this.getFactory();
        synchronized (factory) {
            Object instance = this.getFactory().newInstance();
            this.m_reference = this.getReference(instance);
            return instance;
        }
    }
}

