/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.activation.lifestyle.impl;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import org.apache.avalon.activation.lifecycle.Factory;
import org.apache.avalon.activation.lifestyle.LifestyleHandler;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;

public abstract class AbstractLifestyleHandler
extends AbstractLogEnabled
implements LifestyleHandler {
    private final Factory m_factory;
    private final ReferenceQueue m_liberals = new ReferenceQueue();

    public AbstractLifestyleHandler(Logger logger, Factory factory) {
        this.enableLogging(logger);
        this.m_factory = factory;
    }

    ReferenceQueue getLiberalQueue() {
        return this.m_liberals;
    }

    public void release(Object instance) {
        this.release(instance, false);
    }

    Reference getReference(Object instance) {
        int policy = this.getFactory().getDeploymentModel().getCollectionPolicy();
        if (policy == 0) {
            return new WeakReference<Object>(instance, this.m_liberals);
        }
        if (policy == 1) {
            return new SoftReference<Object>(instance);
        }
        return new StrongReference(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disposeInstance(Object instance) {
        if (instance != null) {
            Factory factory = this.getFactory();
            synchronized (factory) {
                this.m_factory.destroy(instance);
            }
        }
    }

    Object newInstance() throws Exception {
        return this.m_factory.newInstance();
    }

    Factory getFactory() {
        return this.m_factory;
    }

    public abstract /* synthetic */ void release(Object var1, boolean var2);

    public abstract /* synthetic */ Object resolve() throws Exception;

    class StrongReference
    extends WeakReference {
        private final Object m_instance;

        public StrongReference(Object instance) {
            super(instance);
            this.m_instance = instance;
        }

        public Object get() {
            return this.m_instance;
        }
    }
}

