/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.activation.lifestyle.impl;

import org.apache.avalon.activation.lifecycle.Factory;
import org.apache.avalon.activation.lifecycle.LifecycleRuntimeException;
import org.apache.avalon.activation.lifestyle.impl.AbstractLifestyleHandler;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.logger.Logger;

public class ThreadLifestyleHandler
extends AbstractLifestyleHandler
implements Disposable {
    private final Factory m_factory;
    private ThreadLocalHolder m_local;

    public ThreadLifestyleHandler(Logger logger, Factory factory) {
        super(logger, factory);
        this.m_factory = factory;
    }

    public Object resolve() throws Exception {
        if (this.m_local == null) {
            this.m_local = new ThreadLocalHolder(this.m_factory);
        }
        return this.m_local.get();
    }

    public void release(Object instance, boolean finalized) {
        if (finalized) {
            String error = "Not possible because the thread local varliable is holding a hard reference.";
            throw new IllegalStateException("Not possible because the thread local varliable is holding a hard reference.");
        }
    }

    public void dispose() {
        if (this.m_local != null) {
            this.m_factory.destroy(this.m_local.get());
        }
        this.m_local = null;
    }

    private static final class ThreadLocalHolder
    extends ThreadLocal {
        private final Factory m_factory;

        protected ThreadLocalHolder(Factory factory) {
            this.m_factory = factory;
        }

        protected Object initialValue() {
            try {
                return this.m_factory.newInstance();
            }
            catch (Exception e) {
                String error = "Unable to establish thread local variable.";
                throw new LifecycleRuntimeException("Unable to establish thread local variable.");
            }
        }
    }
}

