/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.conformance.util;

import au.org.consumerdatastandards.conformance.ConformanceModel;
import au.org.consumerdatastandards.conformance.Payload;
import au.org.consumerdatastandards.conformance.util.ConformanceUtil;
import au.org.consumerdatastandards.reflection.ReflectionUtil;
import au.org.consumerdatastandards.support.EndpointResponse;
import au.org.consumerdatastandards.support.Extension;
import au.org.consumerdatastandards.support.ResponseCode;
import au.org.consumerdatastandards.support.data.DataDefinition;
import au.org.consumerdatastandards.support.model.APIModel;
import au.org.consumerdatastandards.support.model.EndpointModel;
import au.org.consumerdatastandards.support.model.ParamModel;
import au.org.consumerdatastandards.support.model.SectionModel;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.reflect.FieldUtils;

public class ModelConformanceConverter {
    public static ConformanceModel convert(APIModel apiModel) {
        ConformanceModel conformanceModel = new ConformanceModel();
        HashMap<String, String> endpointVersionMap = new HashMap<String, String>();
        HashMap<String, Map<ResponseCode, EndpointResponse>> responseMap = new HashMap<String, Map<ResponseCode, EndpointResponse>>();
        HashMap payloadMap = new HashMap();
        HashSet processedClasses = new HashSet();
        for (SectionModel sectionModel : apiModel.getSectionModels()) {
            for (EndpointModel endpointModel : sectionModel.getEndpointModels()) {
                ModelConformanceConverter.add(endpointModel, endpointVersionMap, responseMap, payloadMap, processedClasses);
            }
        }
        conformanceModel.setEndpointVersionMap(endpointVersionMap);
        conformanceModel.setResponseMap(responseMap);
        conformanceModel.setPayloadMap(payloadMap);
        return conformanceModel;
    }

    private static void add(EndpointModel endpointModel, Map<String, String> endpointVersionMap, Map<String, Map<ResponseCode, EndpointResponse>> responseMap, Map<Class<?>, Payload> payloadMap, Set<Class<?>> processedClasses) {
        Set bodyParams = endpointModel.getBodyParams();
        if (bodyParams != null && !bodyParams.isEmpty()) {
            ModelConformanceConverter.processBodyParams(endpointModel, bodyParams, payloadMap, processedClasses);
        }
        String operationId = endpointModel.getEndpoint().operationId();
        endpointVersionMap.put(operationId, endpointModel.getCustomAttributeValue(Extension.VERSION.getKey()));
        for (EndpointResponse response : endpointModel.getEndpoint().responses()) {
            responseMap.computeIfAbsent(operationId, k -> new HashMap());
            responseMap.get(operationId).put(response.responseCode(), response);
            ModelConformanceConverter.processResponseBody(endpointModel, response, payloadMap, processedClasses);
        }
    }

    private static void processBodyParams(EndpointModel endpointModel, Set<ParamModel> bodyParams, Map<Class<?>, Payload> payloadMap, Set<Class<?>> processedClasses) {
        for (ParamModel bodyParam : bodyParams) {
            Payload payload = new Payload();
            payload.setDataClass(ModelConformanceConverter.getPayloadDataClass(bodyParam.getParamDataType()));
            payload.setPayloadType(Payload.Type.REQUEST_BODY);
            payload.setEndpointModel(endpointModel);
            payloadMap.put(bodyParam.getParamDataType(), payload);
            ModelConformanceConverter.processDataDefinition(endpointModel, bodyParam.getParamDataType(), payloadMap, processedClasses);
        }
    }

    private static void processResponseBody(EndpointModel endpointModel, EndpointResponse response, Map<Class<?>, Payload> payloadMap, Set<Class<?>> processedClasses) {
        if (!response.content().equals(Void.class)) {
            Payload payload = new Payload();
            payload.setDataClass(ModelConformanceConverter.getPayloadDataClass(response.content()));
            payload.setPayloadType(Payload.Type.RESPONSE_BODY);
            payload.setEndpointModel(endpointModel);
            payloadMap.put(response.content(), payload);
            ModelConformanceConverter.processDataDefinition(endpointModel, response.content(), payloadMap, processedClasses);
        }
    }

    private static void processDataDefinition(EndpointModel endpointModel, Class<?> dataType, Map<Class<?>, Payload> payloadMap, Set<Class<?>> processedClasses) {
        if (!processedClasses.contains(dataType)) {
            for (Field field : FieldUtils.getAllFields(dataType)) {
                Class<?> fieldType = field.getType();
                if (fieldType.isAnnotationPresent(DataDefinition.class) && !fieldType.isEnum()) {
                    ModelConformanceConverter.addPayload(endpointModel, fieldType, payloadMap);
                    ModelConformanceConverter.processDataDefinition(endpointModel, fieldType, payloadMap, processedClasses);
                    continue;
                }
                if (ReflectionUtil.isSetOrList(fieldType)) {
                    Class itemType = ReflectionUtil.getFieldItemType((Field)field);
                    ModelConformanceConverter.addArrayPayload(endpointModel, itemType, payloadMap);
                    if (!itemType.isAnnotationPresent(DataDefinition.class) || itemType.isEnum()) continue;
                    ModelConformanceConverter.addPayload(endpointModel, itemType, payloadMap);
                    ModelConformanceConverter.processDataDefinition(endpointModel, itemType, payloadMap, processedClasses);
                    continue;
                }
                if (!fieldType.isArray()) continue;
                ModelConformanceConverter.addArrayPayload(endpointModel, fieldType.getComponentType(), payloadMap);
                if (!fieldType.getComponentType().isAnnotationPresent(DataDefinition.class) || fieldType.getComponentType().isEnum()) continue;
                ModelConformanceConverter.addPayload(endpointModel, fieldType.getComponentType(), payloadMap);
                ModelConformanceConverter.processDataDefinition(endpointModel, fieldType.getComponentType(), payloadMap, processedClasses);
            }
            DataDefinition dataDefinition = dataType.getAnnotation(DataDefinition.class);
            if (dataDefinition != null && dataDefinition.allOf().length > 0) {
                for (Class clazz : dataDefinition.allOf()) {
                    ModelConformanceConverter.processDataDefinition(endpointModel, clazz, payloadMap, processedClasses);
                }
            }
            processedClasses.add(dataType);
        }
    }

    private static void addPayload(EndpointModel endpointModel, Class<?> dataType, Map<Class<?>, Payload> payloadMap) {
        if (payloadMap.get(dataType) == null) {
            Payload payload = new Payload();
            payload.setDataClass(ModelConformanceConverter.getPayloadDataClass(dataType));
            payload.setPayloadType(Payload.Type.EMBEDDED_DATA);
            payload.setEndpointModel(endpointModel);
            payloadMap.put(dataType, payload);
        }
    }

    private static void addArrayPayload(EndpointModel endpointModel, Class<?> dataType, Map<Class<?>, Payload> payloadMap) {
        Class<?> dataClass = ModelConformanceConverter.getPayloadDataClass(dataType);
        Class<?> generatedArrayType = Array.newInstance(dataClass, 0).getClass();
        Class<?> arrayType = Array.newInstance(dataType, 0).getClass();
        if (payloadMap.get(arrayType) == null) {
            Payload payload = new Payload();
            payload.setDataClass(generatedArrayType);
            payload.setPayloadType(Payload.Type.EMBEDDED_DATA);
            payload.setEndpointModel(endpointModel);
            payloadMap.put(arrayType, payload);
        }
    }

    private static Class<?> getPayloadDataClass(Class<?> dataType) {
        return ConformanceUtil.expandModel(dataType);
    }
}

