/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.conformance.util;

import au.org.consumerdatastandards.conformance.CglibBeanDeserializerModifier;
import au.org.consumerdatastandards.conformance.CglibBeanSerializerModifier;
import au.org.consumerdatastandards.conformance.ConformanceError;
import au.org.consumerdatastandards.reflection.ReflectionUtil;
import au.org.consumerdatastandards.support.data.CDSDataType;
import au.org.consumerdatastandards.support.data.Condition;
import au.org.consumerdatastandards.support.data.ConditionalCDSDataType;
import au.org.consumerdatastandards.support.data.CustomDataType;
import au.org.consumerdatastandards.support.data.DataDefinition;
import au.org.consumerdatastandards.support.data.Property;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.cglib.beans.BeanGenerator;
import org.apache.commons.lang3.reflect.FieldUtils;

public class ConformanceUtil {
    public static final String GENERATED_CLASS_SUFFIX = "$ByCDS";
    public static final String GENERATED_PROPERTY_PREFIX = "$cglib_prop_";

    public static void checkAgainstModel(Object data, Class<?> model, List<ConformanceError> errors) {
        Map<String, Object> propertyValues;
        String[] anyOfProperties = ConformanceUtil.getAnyOfProperties(model);
        if (anyOfProperties != null && anyOfProperties.length > 1 && (propertyValues = ConformanceUtil.getPropertyValues(data, anyOfProperties)).isEmpty()) {
            errors.add(new ConformanceError().errorType(ConformanceError.Type.BROKEN_CONSTRAINT).dataJson(ConformanceUtil.toJson(data)).errorMessage(ConformanceUtil.buildAnyOfErrorMessage(anyOfProperties)));
        }
        List<Field> properties = ConformanceUtil.getAllProperties(model);
        Map<String, Field> propertyMap = ConformanceUtil.buildPropertyMap(properties);
        for (Field modelField : properties) {
            Class itemType;
            Class<?> modelFieldType;
            Object relatedPropertyValue;
            boolean conditionsMet;
            Condition condition;
            Field relatedProperty;
            Condition[] nullIfConditions;
            Condition condition2;
            Field relatedProperty2;
            Object dataFieldValue = ConformanceUtil.getDataFieldValue(data, modelField);
            Property property = modelField.getAnnotation(Property.class);
            if (property.required() && dataFieldValue == null) {
                errors.add(new ConformanceError().errorType(ConformanceError.Type.MISSING_VALUE).dataJson(ConformanceUtil.toJson(data)).errorField(modelField));
            } else if (dataFieldValue != null && modelField.isAnnotationPresent(CDSDataType.class)) {
                CDSDataType cdsDataType = modelField.getAnnotation(CDSDataType.class);
                ConformanceUtil.checkAgainstCDSDataType(data, modelField, dataFieldValue, cdsDataType, errors);
            }
            Condition[] requiredIfConditions = property.requiredIf();
            if (requiredIfConditions.length > 0 && (relatedProperty2 = propertyMap.get((condition2 = requiredIfConditions[0]).propertyName())) != null) {
                Object relatedPropertyValue2 = ConformanceUtil.getDataFieldValue(data, relatedProperty2);
                boolean conditionsMet2 = ConformanceUtil.isValueSpecified(relatedPropertyValue2, condition2.values());
                if (conditionsMet2 && dataFieldValue == null) {
                    errors.add(new ConformanceError().errorType(ConformanceError.Type.MISSING_VALUE).dataJson(ConformanceUtil.toJson(data)).errorField(modelField).errorMessage(String.format("%s is required given %s value is %s", modelField.getName(), relatedProperty2.getName(), relatedPropertyValue2)));
                } else if (conditionsMet2) {
                    CDSDataType requiredCDSDataType = null;
                    ConditionalCDSDataType[] conditionalCDSDataTypes = condition2.conditionalCDSDataTypes();
                    if (conditionalCDSDataTypes.length > 0) {
                        for (ConditionalCDSDataType conditionalCDSDataType : conditionalCDSDataTypes) {
                            if (!conditionalCDSDataType.value().equals("" + relatedPropertyValue2)) continue;
                            requiredCDSDataType = conditionalCDSDataType.cdsDataType();
                        }
                    }
                    if (requiredCDSDataType != null) {
                        ConformanceUtil.checkAgainstCDSDataType(data, modelField, dataFieldValue, requiredCDSDataType, errors);
                    }
                }
            }
            if ((nullIfConditions = property.nullIf()).length > 0 && (relatedProperty = propertyMap.get((condition = nullIfConditions[0]).propertyName())) != null && (conditionsMet = ConformanceUtil.isValueSpecified(relatedPropertyValue = ConformanceUtil.getDataFieldValue(data, relatedProperty), condition.values())) && dataFieldValue != null) {
                errors.add(new ConformanceError().errorType(ConformanceError.Type.REDUNDANT_VALUE).dataJson(ConformanceUtil.toJson(data)).errorField(modelField).errorMessage(String.format("%s should be null given %s value is %s", modelField.getName(), relatedProperty.getName(), relatedPropertyValue)));
            }
            if ((modelFieldType = modelField.getType()).isArray()) {
                if (modelFieldType.getComponentType().isAnnotationPresent(DataDefinition.class) && dataFieldValue != null && Array.getLength(dataFieldValue) > 0) {
                    Object[] values;
                    for (Object value : values = ReflectionUtil.unpack((Object)dataFieldValue)) {
                        ConformanceUtil.checkAgainstModel(value, modelFieldType.getComponentType(), errors);
                    }
                }
            } else if (ReflectionUtil.isSetOrList(modelFieldType) && (itemType = ReflectionUtil.getItemType(modelFieldType, (Type)modelField.getGenericType())).isAnnotationPresent(DataDefinition.class) && dataFieldValue != null) {
                if (dataFieldValue.getClass().isArray()) {
                    Object[] values;
                    for (Object value : values = ReflectionUtil.unpack((Object)dataFieldValue)) {
                        ConformanceUtil.checkAgainstModel(value, itemType, errors);
                    }
                } else {
                    for (Object value : (Collection)dataFieldValue) {
                        ConformanceUtil.checkAgainstModel(value, itemType, errors);
                    }
                }
            }
            if (dataFieldValue == null || !modelFieldType.isAnnotationPresent(DataDefinition.class)) continue;
            ConformanceUtil.checkAgainstModel(dataFieldValue, modelFieldType, errors);
        }
    }

    public static ObjectMapper createObjectMapper() {
        return new ObjectMapper().registerModule((Module)new ParameterNamesModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule()).registerModule((Module)new SimpleModule().setDeserializerModifier((BeanDeserializerModifier)new CglibBeanDeserializerModifier())).registerModule((Module)new SimpleModule().setSerializerModifier((BeanSerializerModifier)new CglibBeanSerializerModifier())).setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
    }

    private static boolean isValueSpecified(Object relatedPropertyValue, String[] values) {
        if (relatedPropertyValue == null) {
            return false;
        }
        for (String value : values) {
            if (!value.equals(relatedPropertyValue.toString())) continue;
            return true;
        }
        return false;
    }

    private static void checkAgainstCDSDataType(Object data, Field modelField, Object dataFieldValue, CDSDataType cdsDataType, List<ConformanceError> errors) {
        Number max;
        Number min;
        CustomDataType customDataType = cdsDataType.value();
        if (customDataType.getPattern() != null && !dataFieldValue.toString().matches(customDataType.getPattern())) {
            errors.add(new ConformanceError().errorType(ConformanceError.Type.PATTERN_NOT_MATCHED).cdsDataType(cdsDataType).dataJson(ConformanceUtil.toJson(data)).errorField(modelField).errorFieldValue(dataFieldValue));
        }
        if ((min = customDataType.getMin()) != null && new BigDecimal(min.toString()).compareTo(new BigDecimal(dataFieldValue.toString())) > 0) {
            errors.add(new ConformanceError().errorType(ConformanceError.Type.NUMBER_TOO_SMALL).cdsDataType(cdsDataType).dataJson(ConformanceUtil.toJson(data)).errorField(modelField).errorFieldValue(dataFieldValue));
        }
        if ((max = customDataType.getMax()) != null && new BigDecimal(max.toString()).compareTo(new BigDecimal(dataFieldValue.toString())) < 0) {
            errors.add(new ConformanceError().errorType(ConformanceError.Type.NUMBER_TOO_BIG).cdsDataType(cdsDataType).dataJson(ConformanceUtil.toJson(data)).errorField(modelField).errorFieldValue(dataFieldValue));
        }
        if (CustomDataType.URI.equals((Object)customDataType)) {
            try {
                new URI(dataFieldValue.toString());
            }
            catch (URISyntaxException e) {
                errors.add(new ConformanceError().errorType(ConformanceError.Type.PATTERN_NOT_MATCHED).cdsDataType(cdsDataType).dataJson(ConformanceUtil.toJson(data)).errorField(modelField).errorFieldValue(dataFieldValue));
            }
        }
    }

    private static String buildAnyOfErrorMessage(String[] anyOfProperties) {
        StringBuilder sb = new StringBuilder("At least one of the [");
        for (int i = 0; i < anyOfProperties.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(anyOfProperties[i]);
        }
        sb.append("] properties should have value, but none of them have values");
        return sb.toString();
    }

    private static List<Field> getAllProperties(Class<?> model) {
        List properties = FieldUtils.getFieldsListWithAnnotation(model, Property.class);
        DataDefinition dataDefinition = model.getAnnotation(DataDefinition.class);
        if (dataDefinition != null && dataDefinition.allOf().length > 0) {
            for (Class clazz : dataDefinition.allOf()) {
                properties.addAll(FieldUtils.getFieldsListWithAnnotation((Class)clazz, Property.class));
            }
        }
        return properties;
    }

    private static Map<String, Field> buildPropertyMap(List<Field> properties) {
        HashMap<String, Field> map = new HashMap<String, Field>();
        properties.forEach(p -> map.put(p.getName(), (Field)p));
        return map;
    }

    private static String[] getAnyOfProperties(Class<?> model) {
        DataDefinition dataDefinition = model.getAnnotation(DataDefinition.class);
        if (dataDefinition != null) {
            return dataDefinition.anyOf();
        }
        return null;
    }

    private static Map<String, Object> getPropertyValues(Object data, String[] properties) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (String property : properties) {
            Object value = ConformanceUtil.getDataFieldValue(data, property);
            if (value == null) continue;
            values.put(property, value);
        }
        return values;
    }

    private static Object getDataFieldValue(Object data, Field modelField) {
        String fieldName = modelField.getName();
        return ConformanceUtil.getDataFieldValue(data, fieldName);
    }

    private static Object getDataFieldValue(Object data, String fieldName) {
        Object dataFieldValue;
        if (ConformanceUtil.isGeneratedClass(data.getClass())) {
            fieldName = GENERATED_PROPERTY_PREFIX + fieldName;
        }
        Field dataField = FieldUtils.getField(data.getClass(), (String)fieldName, (boolean)true);
        dataField.setAccessible(true);
        try {
            dataFieldValue = dataField.get(data);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        return dataFieldValue;
    }

    private static boolean isGeneratedClass(Class<?> clazz) {
        return clazz.getSimpleName().endsWith(GENERATED_CLASS_SUFFIX);
    }

    public static Class<?> expandModel(Class<?> modelClass) {
        if (ConformanceUtil.allOfExists(modelClass)) {
            DataDefinition dataDefinition = modelClass.getAnnotation(DataDefinition.class);
            if (dataDefinition != null && dataDefinition.allOf().length > 0) {
                return ConformanceUtil.combine(modelClass, dataDefinition.allOf());
            }
            BeanGenerator beanGenerator = new BeanGenerator();
            beanGenerator.setNamingPolicy((s, s1, o, predicate) -> modelClass.getName() + GENERATED_CLASS_SUFFIX);
            ConformanceUtil.addProperties(beanGenerator, modelClass);
            return (Class)beanGenerator.createClass();
        }
        return modelClass;
    }

    private static Class<?> combine(Class<?> primaryClass, Class<?>[] allOf) {
        BeanGenerator beanGenerator = new BeanGenerator();
        beanGenerator.setNamingPolicy((s, s1, o, predicate) -> primaryClass.getName() + GENERATED_CLASS_SUFFIX);
        ConformanceUtil.addProperties(beanGenerator, primaryClass);
        for (Class<?> clazz : allOf) {
            ConformanceUtil.addProperties(beanGenerator, clazz);
        }
        return (Class)beanGenerator.createClass();
    }

    private static boolean allOfExists(Class<?> modelClass) {
        Field[] allFields;
        if (modelClass.isEnum() || !ReflectionUtil.isCDSModel(modelClass)) {
            return false;
        }
        DataDefinition dataDefinition = modelClass.getAnnotation(DataDefinition.class);
        if (dataDefinition != null && dataDefinition.allOf().length > 0) {
            return true;
        }
        for (Field field : allFields = FieldUtils.getAllFields(modelClass)) {
            Class itemType;
            if (!(ReflectionUtil.isSetOrList(field.getType()) ? ConformanceUtil.allOfExists(itemType = ReflectionUtil.getItemType(field.getType(), (Type)field.getGenericType())) : ConformanceUtil.allOfExists(field.getType()))) continue;
            return true;
        }
        return false;
    }

    private static void addProperties(BeanGenerator beanGenerator, Class<?> clazz) {
        Field[] allFields;
        for (Field field : allFields = FieldUtils.getAllFields(clazz)) {
            beanGenerator.addProperty(field.getName(), ConformanceUtil.getFieldType(field));
        }
    }

    private static Class<?> getFieldType(Field field) {
        if (ReflectionUtil.isSetOrList(field.getType())) {
            Class itemType = ReflectionUtil.getItemType(field.getType(), (Type)field.getGenericType());
            return Array.newInstance(ConformanceUtil.expandModel(itemType), 0).getClass();
        }
        return ConformanceUtil.expandModel(field.getType());
    }

    public static String toJson(Object dataObject) {
        try {
            return ConformanceUtil.createObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(dataObject);
        }
        catch (JsonProcessingException e) {
            return dataObject.toString();
        }
    }

    public static String getFieldName(Object dataObject, String originalFieldName) {
        if (ConformanceUtil.isGeneratedClass(dataObject.getClass())) {
            return GENERATED_PROPERTY_PREFIX + originalFieldName;
        }
        return originalFieldName;
    }
}

