/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.conformance;

import au.org.consumerdatastandards.support.data.CDSDataType;
import au.org.consumerdatastandards.support.data.CustomDataType;
import java.lang.reflect.Field;
import org.apache.commons.lang3.StringUtils;

public class ConformanceError {
    private String dataJson;
    private Type errorType;
    private Field errorField;
    private Object errorFieldValue;
    private CDSDataType cdsDataType;
    private String message;

    public ConformanceError dataJson(String dataJson) {
        this.dataJson = dataJson;
        return this;
    }

    public ConformanceError errorType(Type errorType) {
        this.errorType = errorType;
        return this;
    }

    public ConformanceError errorField(Field errorField) {
        this.errorField = errorField;
        return this;
    }

    public ConformanceError errorFieldValue(Object errorFieldValue) {
        this.errorFieldValue = errorFieldValue;
        return this;
    }

    public ConformanceError cdsDataType(CDSDataType cdsDataType) {
        this.cdsDataType = cdsDataType;
        return this;
    }

    public ConformanceError errorMessage(String message) {
        this.message = message;
        return this;
    }

    public String getDescription() {
        switch (this.errorType) {
            case MISSING_VALUE: {
                return String.format("Required field '%s' has null value in\n%s", this.errorField.getName().replace("$cglib_prop_", ""), this.dataJson);
            }
            case MISSING_PROPERTY: {
                return String.format("Required field '%s' is missing in\n%s", this.errorField.getName().replace("$cglib_prop_", ""), this.dataJson);
            }
            case PATTERN_NOT_MATCHED: {
                CustomDataType customDataType = this.cdsDataType.value();
                return String.format("%s '%s' does not conform to CDS type %s. See below:\n%s", this.errorField.getName().replace("$cglib_prop_", ""), this.errorFieldValue, customDataType.getName(), this.dataJson);
            }
            case NUMBER_TOO_SMALL: {
                CustomDataType customType = this.cdsDataType.value();
                return String.format("%s '%s' is smaller than CDS type %s minimum value %s. See below:\n%s", this.errorField.getName().replace("$cglib_prop_", ""), this.errorFieldValue, customType.getName(), customType.getMin(), this.dataJson);
            }
            case NUMBER_TOO_BIG: {
                CustomDataType dataType = this.cdsDataType.value();
                return String.format("%s '%s' is bigger than CDS type %s max value %s. See below:\n%s", this.errorField.getName().replace("$cglib_prop_", ""), this.errorFieldValue, dataType.getName(), dataType.getMax(), this.dataJson);
            }
        }
        if (!StringUtils.isBlank((CharSequence)this.message)) {
            return this.message;
        }
        return "Unknown error";
    }

    public static enum Type {
        MISSING_PROPERTY,
        MISSING_VALUE,
        NO_MATCHING_MODEL,
        BROKEN_CONSTRAINT,
        PATTERN_NOT_MATCHED,
        NUMBER_TOO_SMALL,
        NUMBER_TOO_BIG,
        DATA_NOT_MATCHING_CRITERIA;

    }
}

