/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.service;

import au.org.consumerdatastandards.holder.model.BankingProduct;
import au.org.consumerdatastandards.holder.model.ParamEffective;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.util.StringUtils;

class BankingProductSpecification<T>
implements Specification<T> {
    private final ParamEffective effective;
    private final BankingProduct bankingProduct;

    public BankingProductSpecification(ParamEffective effective, BankingProduct bankingProduct) {
        this.effective = effective;
        this.bankingProduct = bankingProduct;
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (ParamEffective.CURRENT.equals((Object)this.effective) || this.effective == null) {
            OffsetDateTime now = OffsetDateTime.now();
            predicates.add(criteriaBuilder.lessThanOrEqualTo((Expression)root.get("effectiveFrom"), (Comparable)now));
            predicates.add(criteriaBuilder.greaterThanOrEqualTo((Expression)root.get("effectiveTo"), (Comparable)now));
        } else if (ParamEffective.FUTURE.equals((Object)this.effective)) {
            OffsetDateTime now = OffsetDateTime.now();
            predicates.add(criteriaBuilder.greaterThan((Expression)root.get("effectiveFrom"), (Comparable)now));
        }
        if (this.bankingProduct.getProductCategory() != null) {
            predicates.add(criteriaBuilder.equal((Expression)root.get("productCategory"), (Object)this.bankingProduct.getProductCategory()));
        }
        if (this.bankingProduct.getLastUpdated() != null) {
            predicates.add(criteriaBuilder.greaterThanOrEqualTo((Expression)root.get("lastUpdated"), (Comparable)this.bankingProduct.getLastUpdated()));
        }
        if (!StringUtils.isEmpty((Object)this.bankingProduct.getBrand())) {
            predicates.add(criteriaBuilder.like((Expression)root.get("brand"), "%" + this.bankingProduct.getBrand() + "%"));
        }
        return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
    }
}

