/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.service;

import au.org.consumerdatastandards.holder.api.VersionNotSupportedException;
import au.org.consumerdatastandards.holder.model.BankingProduct;
import au.org.consumerdatastandards.holder.model.BankingProductDetail;
import au.org.consumerdatastandards.holder.model.ParamEffective;
import au.org.consumerdatastandards.holder.repository.BankingProductV1DetailRepository;
import au.org.consumerdatastandards.holder.repository.BankingProductV1Repository;
import au.org.consumerdatastandards.holder.repository.BankingProductV2DetailRepository;
import au.org.consumerdatastandards.holder.repository.BankingProductV2Repository;
import au.org.consumerdatastandards.holder.repository.BankingProductV3DetailRepository;
import au.org.consumerdatastandards.holder.service.BankingProductSpecification;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class BankingProductService {
    private static final Logger LOGGER = LogManager.getLogger(BankingProductService.class);
    private final BankingProductV1Repository productsV1Repository;
    private final BankingProductV2Repository productsV2Repository;
    private final BankingProductV2Repository productsV3Repository;
    private final BankingProductV1DetailRepository productDetailV1Repository;
    private final BankingProductV2DetailRepository productDetailV2Repository;
    private final BankingProductV3DetailRepository productDetailV3Repository;

    @Autowired
    public BankingProductService(BankingProductV1Repository productsV1Repository, BankingProductV2Repository productsV2Repository, BankingProductV2Repository productsV3Repository, BankingProductV1DetailRepository productDetailV1Repository, BankingProductV2DetailRepository productDetailV2Repository, BankingProductV3DetailRepository productDetailV3Repository) {
        this.productsV1Repository = productsV1Repository;
        this.productsV2Repository = productsV2Repository;
        this.productsV3Repository = productsV3Repository;
        this.productDetailV1Repository = productDetailV1Repository;
        this.productDetailV2Repository = productDetailV2Repository;
        this.productDetailV3Repository = productDetailV3Repository;
    }

    public Page<BankingProduct> findProductsLike(ParamEffective effective, BankingProduct bankingProduct, Pageable pageable, Integer version) {
        LOGGER.debug("Retrieve products matching inputs of effective {}, BankingProduct specified as {} with Paging content specified as {}", (Object)effective, (Object)bankingProduct, (Object)pageable);
        switch (version) {
            case 1: {
                return this.productsV1Repository.findAll((Specification)new BankingProductSpecification(effective, bankingProduct), pageable).map(productV1 -> productV1);
            }
            case 2: {
                return this.productsV2Repository.findAll((Specification)new BankingProductSpecification(effective, bankingProduct), pageable).map(productV2 -> productV2);
            }
            case 3: {
                return this.productsV3Repository.findAll((Specification)new BankingProductSpecification(effective, bankingProduct), pageable).map(productV3 -> productV3);
            }
        }
        throw new VersionNotSupportedException("Unsupported version " + version);
    }

    public BankingProductDetail getProductDetail(String productId, Integer version) {
        LOGGER.debug("Retrieving product detail by id {}", (Object)productId);
        switch (version) {
            case 1: {
                return this.productDetailV1Repository.findById((Object)productId).orElse(null);
            }
            case 2: {
                return this.productDetailV2Repository.findById((Object)productId).orElse(null);
            }
            case 3: {
                return this.productDetailV3Repository.findById((Object)productId).orElse(null);
            }
        }
        throw new VersionNotSupportedException("Unsupported version " + version);
    }
}

