/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.model;

import au.org.consumerdatastandards.holder.model.CommonEmailAddress;
import au.org.consumerdatastandards.holder.model.CommonPhoneNumber;
import au.org.consumerdatastandards.holder.model.CommonPhysicalAddressWithPurpose;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;

@ApiModel
@Entity
@Table(name="CommonPerson")
public class CommonPersonDetail {
    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid2")
    @JsonIgnore
    private String id;
    private String firstName;
    private String lastName;
    private OffsetDateTime lastUpdateTime;
    @ElementCollection
    private List<String> middleNames;
    private String occupationCode;
    private String prefix;
    private String suffix;
    @OneToMany
    @JoinTable(name="person_email_addresses", joinColumns={@JoinColumn(name="person_id")}, inverseJoinColumns={@JoinColumn(name="email_address_id")})
    private List<CommonEmailAddress> emailAddresses;
    @OneToMany
    @JoinTable(name="person_phone_numbers", joinColumns={@JoinColumn(name="person_id")}, inverseJoinColumns={@JoinColumn(name="phone_number_id")})
    private List<CommonPhoneNumber> phoneNumbers;
    @OneToMany
    @JoinTable(name="person_physical_addresses", joinColumns={@JoinColumn(name="person_id")}, inverseJoinColumns={@JoinColumn(name="physical_address_id")})
    private List<CommonPhysicalAddressWithPurpose> physicalAddresses;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public OffsetDateTime getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(OffsetDateTime lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public List<String> getMiddleNames() {
        return this.middleNames;
    }

    public void setMiddleNames(List<String> middleNames) {
        this.middleNames = middleNames;
    }

    public String getOccupationCode() {
        return this.occupationCode;
    }

    public void setOccupationCode(String occupationCode) {
        this.occupationCode = occupationCode;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public CommonPersonDetail firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public CommonPersonDetail lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public CommonPersonDetail lastUpdateTime(OffsetDateTime lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
        return this;
    }

    public CommonPersonDetail middleNames(List<String> middleNames) {
        this.middleNames = middleNames;
        return this;
    }

    public CommonPersonDetail addItem(String middleNamesItem) {
        this.middleNames.add(middleNamesItem);
        return this;
    }

    public CommonPersonDetail occupationCode(String occupationCode) {
        this.occupationCode = occupationCode;
        return this;
    }

    public CommonPersonDetail prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public CommonPersonDetail suffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public CommonPersonDetail emailAddresses(List<CommonEmailAddress> emailAddresses) {
        this.emailAddresses = emailAddresses;
        return this;
    }

    public CommonPersonDetail addItem(CommonEmailAddress emailAddressesItem) {
        this.emailAddresses.add(emailAddressesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="May be empty")
    public List<CommonEmailAddress> getEmailAddresses() {
        return this.emailAddresses;
    }

    public void setEmailAddresses(List<CommonEmailAddress> emailAddresses) {
        this.emailAddresses = emailAddresses;
    }

    public CommonPersonDetail phoneNumbers(List<CommonPhoneNumber> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
        return this;
    }

    public CommonPersonDetail addItem(CommonPhoneNumber phoneNumbersItem) {
        this.phoneNumbers.add(phoneNumbersItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array is mandatory but may be empty if no phone numbers are held")
    public List<CommonPhoneNumber> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public void setPhoneNumbers(List<CommonPhoneNumber> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
    }

    public CommonPersonDetail physicalAddresses(List<CommonPhysicalAddressWithPurpose> physicalAddresses) {
        this.physicalAddresses = physicalAddresses;
        return this;
    }

    public CommonPersonDetail addItem(CommonPhysicalAddressWithPurpose physicalAddressesItem) {
        this.physicalAddresses.add(physicalAddressesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Must contain at least one address. One and only one address may have the purpose of REGISTERED. Zero or one, and no more than one, record may have the purpose of MAIL. If zero then the REGISTERED address is to be used for mail")
    public List<CommonPhysicalAddressWithPurpose> getPhysicalAddresses() {
        return this.physicalAddresses;
    }

    public void setPhysicalAddresses(List<CommonPhysicalAddressWithPurpose> physicalAddresses) {
        this.physicalAddresses = physicalAddresses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommonPersonDetail commonPersonDetail = (CommonPersonDetail)o;
        return Objects.equals(this.emailAddresses, commonPersonDetail.emailAddresses) && Objects.equals(this.phoneNumbers, commonPersonDetail.phoneNumbers) && Objects.equals(this.physicalAddresses, commonPersonDetail.physicalAddresses) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(this.emailAddresses, this.phoneNumbers, this.physicalAddresses, super.hashCode());
    }

    public String toString() {
        return "class CommonPersonDetail {\n   id: " + this.toIndentedString((Object)this.id) + "\n   firstName: " + this.toIndentedString((Object)this.getFirstName()) + "\n   lastName: " + this.toIndentedString((Object)this.getLastName()) + "\n   lastUpdateTime: " + this.toIndentedString((Object)this.getLastUpdateTime()) + "\n   middleNames: " + this.toIndentedString((Object)this.getMiddleNames()) + "\n   occupationCode: " + this.toIndentedString((Object)this.getOccupationCode()) + "\n   prefix: " + this.toIndentedString((Object)this.getPrefix()) + "\n   suffix: " + this.toIndentedString((Object)this.getSuffix()) + "\n   emailAddresses: " + this.toIndentedString((Object)this.emailAddresses) + "\n   phoneNumbers: " + this.toIndentedString((Object)this.phoneNumbers) + "\n   physicalAddresses: " + this.toIndentedString((Object)this.physicalAddresses) + "\n}";
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

