/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.model;

import au.org.consumerdatastandards.holder.model.BankingBillerPayee;
import au.org.consumerdatastandards.holder.model.BankingDomesticPayee;
import au.org.consumerdatastandards.holder.model.BankingInternationalPayee;
import au.org.consumerdatastandards.holder.model.BankingScheduledPaymentTo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import org.hibernate.annotations.GenericGenerator;

@ApiModel(description="Object containing details of the destination of the payment. Used to specify a variety of payment destination types")
@Entity
public class BankingScheduledPaymentTo {
    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid2")
    @JsonIgnore
    private String id;
    private String accountId;
    @ManyToOne
    private BankingBillerPayee biller;
    @ManyToOne
    private BankingDomesticPayee domestic;
    @ManyToOne
    private BankingInternationalPayee international;
    private String payeeId;
    private ToUType toUType;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BankingScheduledPaymentTo accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(value="Present if toUType is set to accountId. Indicates that the payment is to another account that is accessible under the current consent")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public BankingScheduledPaymentTo biller(BankingBillerPayee biller) {
        this.biller = biller;
        return this;
    }

    @ApiModelProperty
    public BankingBillerPayee getBiller() {
        return this.biller;
    }

    public void setBiller(BankingBillerPayee biller) {
        this.biller = biller;
    }

    public BankingScheduledPaymentTo domestic(BankingDomesticPayee domestic) {
        this.domestic = domestic;
        return this;
    }

    @ApiModelProperty
    public BankingDomesticPayee getDomestic() {
        return this.domestic;
    }

    public void setDomestic(BankingDomesticPayee domestic) {
        this.domestic = domestic;
    }

    public BankingScheduledPaymentTo international(BankingInternationalPayee international) {
        this.international = international;
        return this;
    }

    @ApiModelProperty
    public BankingInternationalPayee getInternational() {
        return this.international;
    }

    public void setInternational(BankingInternationalPayee international) {
        this.international = international;
    }

    public BankingScheduledPaymentTo payeeId(String payeeId) {
        this.payeeId = payeeId;
        return this;
    }

    @ApiModelProperty(value="Present if toUType is set to payeeId. Indicates that the payment is to registered payee that can be accessed using the payee end point. If the Bank Payees scope has not been consented to then a payeeId should not be provided and the full payee details should be provided instead")
    public String getPayeeId() {
        return this.payeeId;
    }

    public void setPayeeId(String payeeId) {
        this.payeeId = payeeId;
    }

    public BankingScheduledPaymentTo toUType(ToUType toUType) {
        this.toUType = toUType;
        return this;
    }

    @ApiModelProperty(required=true)
    public ToUType getToUType() {
        return this.toUType;
    }

    public void setToUType(ToUType toUType) {
        this.toUType = toUType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankingScheduledPaymentTo bankingScheduledPaymentTo = (BankingScheduledPaymentTo)o;
        return Objects.equals(this.id, bankingScheduledPaymentTo.id) && Objects.equals(this.accountId, bankingScheduledPaymentTo.accountId) && Objects.equals(this.biller, bankingScheduledPaymentTo.biller) && Objects.equals(this.domestic, bankingScheduledPaymentTo.domestic) && Objects.equals(this.international, bankingScheduledPaymentTo.international) && Objects.equals(this.payeeId, bankingScheduledPaymentTo.payeeId) && Objects.equals(this.toUType, bankingScheduledPaymentTo.toUType);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.accountId, this.biller, this.domestic, this.international, this.payeeId, this.toUType);
    }

    public String toString() {
        return "class BankingScheduledPaymentTo {\n   id: " + this.toIndentedString((Object)this.id) + "\n   accountId: " + this.toIndentedString((Object)this.accountId) + "\n   biller: " + this.toIndentedString((Object)this.biller) + "\n   domestic: " + this.toIndentedString((Object)this.domestic) + "\n   international: " + this.toIndentedString((Object)this.international) + "\n   payeeId: " + this.toIndentedString((Object)this.payeeId) + "\n   toUType: " + this.toIndentedString((Object)this.toUType) + "\n}";
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

