/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.model;

import au.org.consumerdatastandards.holder.model.BankingScheduledPaymentRecurrenceLastWeekday;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Embeddable;

@ApiModel(description="Indicates that the schedule of payments is defined according to the last occurrence of a specific weekday in an interval. Mandatory if recurrenceUType is set to lastWeekDay")
@Embeddable
public class BankingScheduledPaymentRecurrenceLastWeekday {
    private LocalDate finalPaymentDate;
    @Column(name="interv")
    private String interval;
    private LastWeekDay lastWeekDay;
    private Integer paymentsRemaining;
    private NonBusinessDayTreatment nonBusinessDayTreatment = NonBusinessDayTreatment.ON;

    public BankingScheduledPaymentRecurrenceLastWeekday finalPaymentDate(LocalDate finalPaymentDate) {
        this.finalPaymentDate = finalPaymentDate;
        return this;
    }

    @ApiModelProperty(value="The limit date after which no more payments should be made using this schedule. If both finalPaymentDate and paymentsRemaining are present then payments will stop according to the most constraining value. If neither field is present the payments will continue indefinitely")
    public LocalDate getFinalPaymentDate() {
        return this.finalPaymentDate;
    }

    public void setFinalPaymentDate(LocalDate finalPaymentDate) {
        this.finalPaymentDate = finalPaymentDate;
    }

    public BankingScheduledPaymentRecurrenceLastWeekday interval(String interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(required=true, value="The interval for the payment. Formatted according to [ISO 8601 Durations](https://en.wikipedia.org/wiki/ISO_8601#Durations) with components less than a day in length ignored. This duration defines the period between payments starting with nextPaymentDate")
    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public BankingScheduledPaymentRecurrenceLastWeekday lastWeekDay(LastWeekDay lastWeekDay) {
        this.lastWeekDay = lastWeekDay;
        return this;
    }

    @ApiModelProperty(required=true, value="The weekDay specified. The payment will occur on the last occurrence of this weekday in the interval. Value is constrained to 1 to 7 with 1 indicating Monday.")
    public LastWeekDay getLastWeekDay() {
        return this.lastWeekDay;
    }

    public void setLastWeekDay(LastWeekDay lastWeekDay) {
        this.lastWeekDay = lastWeekDay;
    }

    public BankingScheduledPaymentRecurrenceLastWeekday paymentsRemaining(Integer paymentsRemaining) {
        this.paymentsRemaining = paymentsRemaining;
        return this;
    }

    @ApiModelProperty(value="Indicates the number of payments remaining in the schedule. If both finalPaymentDate and paymentsRemaining are present then payments will stop according to the most constraining value. If neither field is present the payments will continue indefinitely")
    public Integer getPaymentsRemaining() {
        return this.paymentsRemaining;
    }

    public void setPaymentsRemaining(Integer paymentsRemaining) {
        this.paymentsRemaining = paymentsRemaining;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankingScheduledPaymentRecurrenceLastWeekday bankingScheduledPaymentRecurrenceLastWeekday = (BankingScheduledPaymentRecurrenceLastWeekday)o;
        return Objects.equals(this.finalPaymentDate, bankingScheduledPaymentRecurrenceLastWeekday.finalPaymentDate) && Objects.equals(this.interval, bankingScheduledPaymentRecurrenceLastWeekday.interval) && Objects.equals(this.lastWeekDay, bankingScheduledPaymentRecurrenceLastWeekday.lastWeekDay) && Objects.equals(this.paymentsRemaining, bankingScheduledPaymentRecurrenceLastWeekday.paymentsRemaining);
    }

    public int hashCode() {
        return Objects.hash(this.finalPaymentDate, this.interval, this.lastWeekDay, this.paymentsRemaining);
    }

    public String toString() {
        return "class BankingScheduledPaymentRecurrenceLastWeekday {\n   finalPaymentDate: " + this.toIndentedString((Object)this.finalPaymentDate) + "\n   interval: " + this.toIndentedString((Object)this.interval) + "\n   lastWeekDay: " + this.toIndentedString((Object)this.lastWeekDay) + "\n   paymentsRemaining: " + this.toIndentedString((Object)this.paymentsRemaining) + "\n}";
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

