/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.model;

import au.org.consumerdatastandards.holder.model.BankingScheduledPaymentInterval;
import au.org.consumerdatastandards.holder.model.BankingScheduledPaymentRecurrenceIntervalSchedule;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.format.annotation.DateTimeFormat;

@ApiModel(description="Indicates that the schedule of payments is defined by a series of intervals. Mandatory if recurrenceUType is set to intervalSchedule")
@Entity
public class BankingScheduledPaymentRecurrenceIntervalSchedule {
    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid2")
    @JsonIgnore
    private String id;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private LocalDate finalPaymentDate;
    @OneToMany
    @JoinTable(name="banking_scheduled_payment_intervals", joinColumns={@JoinColumn(name="interval_schedule_id")}, inverseJoinColumns={@JoinColumn(name="interval_id")})
    private List<BankingScheduledPaymentInterval> intervals;
    private NonBusinessDayTreatment nonBusinessDayTreatment;
    private Integer paymentsRemaining;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BankingScheduledPaymentRecurrenceIntervalSchedule finalPaymentDate(LocalDate finalPaymentDate) {
        this.finalPaymentDate = finalPaymentDate;
        return this;
    }

    @ApiModelProperty(value="The limit date after which no more payments should be made using this schedule. If both finalPaymentDate and paymentsRemaining are present then payments will stop according to the most constraining value. If neither field is present the payments will continue indefinitely")
    public LocalDate getFinalPaymentDate() {
        return this.finalPaymentDate;
    }

    public void setFinalPaymentDate(LocalDate finalPaymentDate) {
        this.finalPaymentDate = finalPaymentDate;
    }

    public BankingScheduledPaymentRecurrenceIntervalSchedule intervals(List<BankingScheduledPaymentInterval> intervals) {
        this.intervals = intervals;
        return this;
    }

    public BankingScheduledPaymentRecurrenceIntervalSchedule addItem(BankingScheduledPaymentInterval intervalsItem) {
        this.intervals.add(intervalsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of interval objects defining the payment schedule.  Each entry in the array is additive, in that it adds payments to the overall payment schedule.  If multiple intervals result in a payment on the same day then only one payment will be made. Must have at least one entry")
    public List<BankingScheduledPaymentInterval> getIntervals() {
        return this.intervals;
    }

    public void setIntervals(List<BankingScheduledPaymentInterval> intervals) {
        this.intervals = intervals;
    }

    public BankingScheduledPaymentRecurrenceIntervalSchedule nonBusinessDayTreatment(NonBusinessDayTreatment nonBusinessDayTreatment) {
        this.nonBusinessDayTreatment = nonBusinessDayTreatment;
        return this;
    }

    @ApiModelProperty
    public NonBusinessDayTreatment getNonBusinessDayTreatment() {
        return this.nonBusinessDayTreatment;
    }

    public void setNonBusinessDayTreatment(NonBusinessDayTreatment nonBusinessDayTreatment) {
        this.nonBusinessDayTreatment = nonBusinessDayTreatment;
    }

    public BankingScheduledPaymentRecurrenceIntervalSchedule paymentsRemaining(Integer paymentsRemaining) {
        this.paymentsRemaining = paymentsRemaining;
        return this;
    }

    @ApiModelProperty(value="Indicates the number of payments remaining in the schedule. If both finalPaymentDate and paymentsRemaining are present then payments will stop according to the most constraining value, If neither field is present the payments will continue indefinitely")
    public Integer getPaymentsRemaining() {
        return this.paymentsRemaining;
    }

    public void setPaymentsRemaining(Integer paymentsRemaining) {
        this.paymentsRemaining = paymentsRemaining;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankingScheduledPaymentRecurrenceIntervalSchedule bankingScheduledPaymentRecurrenceIntervalSchedule = (BankingScheduledPaymentRecurrenceIntervalSchedule)o;
        return Objects.equals(this.id, bankingScheduledPaymentRecurrenceIntervalSchedule.id) && Objects.equals(this.finalPaymentDate, bankingScheduledPaymentRecurrenceIntervalSchedule.finalPaymentDate) && Objects.equals(this.intervals, bankingScheduledPaymentRecurrenceIntervalSchedule.intervals) && Objects.equals(this.nonBusinessDayTreatment, bankingScheduledPaymentRecurrenceIntervalSchedule.nonBusinessDayTreatment) && Objects.equals(this.paymentsRemaining, bankingScheduledPaymentRecurrenceIntervalSchedule.paymentsRemaining);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.finalPaymentDate, this.intervals, this.nonBusinessDayTreatment, this.paymentsRemaining);
    }

    public String toString() {
        return "class BankingScheduledPaymentRecurrenceIntervalSchedule {\n   id: " + this.toIndentedString((Object)this.id) + "\n   finalPaymentDate: " + this.toIndentedString((Object)this.finalPaymentDate) + "\n   intervals: " + this.toIndentedString((Object)this.intervals) + "\n   nonBusinessDayTreatment: " + this.toIndentedString((Object)this.nonBusinessDayTreatment) + "\n   paymentsRemaining: " + this.toIndentedString((Object)this.paymentsRemaining) + "\n}";
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

