/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.model;

import au.org.consumerdatastandards.holder.model.BankingAccount;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.persistence.Embeddable;
import javax.persistence.ManyToOne;

@ApiModel(description="Object containing details of the source of the payment. Currently only specifies an account ID but provided as an object to facilitate future extensibility and consistency with the to object")
@Embeddable
public class BankingScheduledPaymentFrom {
    private String accountId;
    @ManyToOne
    @JsonIgnore
    private BankingAccount bankingAccount;

    public BankingScheduledPaymentFrom accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="ID of the account that is the source of funds for the payment")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public BankingAccount getBankingAccount() {
        return this.bankingAccount;
    }

    public void setBankingAccount(BankingAccount bankingAccount) {
        this.bankingAccount = bankingAccount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankingScheduledPaymentFrom bankingScheduledPaymentFrom = (BankingScheduledPaymentFrom)o;
        return Objects.equals(this.accountId, bankingScheduledPaymentFrom.accountId);
    }

    public int hashCode() {
        return Objects.hash(this.accountId);
    }

    public String toString() {
        return "class BankingScheduledPaymentFrom {\n   accountId: " + this.toIndentedString((Object)this.accountId) + "\n}";
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

