/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.model;

import au.org.consumerdatastandards.holder.model.BankingProductDiscount;
import au.org.consumerdatastandards.holder.model.BankingProductFee;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import org.hibernate.annotations.GenericGenerator;

@Entity
public class BankingProductFee {
    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid2")
    @JsonIgnore
    private String feeId;
    private String name;
    private FeeType feeType;
    private BigDecimal amount;
    private BigDecimal balanceRate;
    private BigDecimal transactionRate;
    private BigDecimal accruedRate;
    private String accrualFrequency;
    private String currency;
    @Column(length=2048)
    private String additionalValue;
    @Column(length=2048)
    private String additionalInfo;
    private URI additionalInfoUri;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="product_fee_discounts", joinColumns={@JoinColumn(name="product_fee_id")}, inverseJoinColumns={@JoinColumn(name="product_discount_id")})
    private List<BankingProductDiscount> discounts;

    public String getFeeId() {
        return this.feeId;
    }

    public void setFeeId(String feeId) {
        this.feeId = feeId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FeeType getFeeType() {
        return this.feeType;
    }

    public void setFeeType(FeeType feeType) {
        this.feeType = feeType;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public BigDecimal getBalanceRate() {
        return this.balanceRate;
    }

    public void setBalanceRate(BigDecimal balanceRate) {
        this.balanceRate = balanceRate;
    }

    public BigDecimal getTransactionRate() {
        return this.transactionRate;
    }

    public void setTransactionRate(BigDecimal transactionRate) {
        this.transactionRate = transactionRate;
    }

    public BigDecimal getAccruedRate() {
        return this.accruedRate;
    }

    public void setAccruedRate(BigDecimal accruedRate) {
        this.accruedRate = accruedRate;
    }

    public String getAccrualFrequency() {
        return this.accrualFrequency;
    }

    public void setAccrualFrequency(String accrualFrequency) {
        this.accrualFrequency = accrualFrequency;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getAdditionalValue() {
        return this.additionalValue;
    }

    public void setAdditionalValue(String additionalValue) {
        this.additionalValue = additionalValue;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public URI getAdditionalInfoUri() {
        return this.additionalInfoUri;
    }

    public void setAdditionalInfoUri(URI additionalInfoUri) {
        this.additionalInfoUri = additionalInfoUri;
    }

    public List<BankingProductDiscount> getDiscounts() {
        return this.discounts;
    }

    public void setDiscounts(List<BankingProductDiscount> discounts) {
        this.discounts = discounts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankingProductFee that = (BankingProductFee)o;
        return Objects.equals(this.feeId, that.feeId);
    }

    public int hashCode() {
        return Objects.hash(this.feeId);
    }

    public String toString() {
        return "BankingProductFee{feeId='" + this.feeId + '\'' + ", name='" + this.name + '\'' + ", feeType=" + this.feeType + ", amount=" + this.amount + ", balanceRate=" + this.balanceRate + ", transactionRate=" + this.transactionRate + ", accruedRate=" + this.accruedRate + ", accrualFrequency='" + this.accrualFrequency + '\'' + ", currency='" + this.currency + '\'' + ", additionalValue='" + this.additionalValue + '\'' + ", additionalInfo='" + this.additionalInfo + '\'' + ", additionalInfoUri=" + this.additionalInfoUri + ", discounts=" + this.discounts + '}';
    }
}

