/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.model;

import au.org.consumerdatastandards.holder.model.BankingPayee;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import org.springframework.format.annotation.DateTimeFormat;

@ApiModel
@Entity
@Table(name="BankingPayee")
public class BankingPayee {
    @Id
    private String payeeId;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private LocalDate creationDate;
    private String description;
    private String nickname;
    private Type type;

    public BankingPayee creationDate(LocalDate creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @ApiModelProperty(value="The date the payee was created by the customer")
    public LocalDate getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(LocalDate creationDate) {
        this.creationDate = creationDate;
    }

    public BankingPayee description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="A description of the payee provided by the customer")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BankingPayee nickname(String nickname) {
        this.nickname = nickname;
        return this;
    }

    @ApiModelProperty(required=true, value="The short display name of the payee as provided by the customer")
    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public BankingPayee payeeId(String payeeId) {
        this.payeeId = payeeId;
        return this;
    }

    @ApiModelProperty(required=true, value="ID of the payee adhering to the rules of ID permanence")
    public String getPayeeId() {
        return this.payeeId;
    }

    public void setPayeeId(String payeeId) {
        this.payeeId = payeeId;
    }

    public BankingPayee type(Type type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true)
    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankingPayee bankingPayee = (BankingPayee)o;
        return Objects.equals(this.creationDate, bankingPayee.creationDate) && Objects.equals(this.description, bankingPayee.description) && Objects.equals(this.nickname, bankingPayee.nickname) && Objects.equals(this.payeeId, bankingPayee.payeeId) && Objects.equals(this.type, bankingPayee.type);
    }

    public int hashCode() {
        return Objects.hash(this.creationDate, this.description, this.nickname, this.payeeId, this.type);
    }

    public String toString() {
        return "class BankingPayee {\n   creationDate: " + this.toIndentedString((Object)this.creationDate) + "\n   description: " + this.toIndentedString((Object)this.description) + "\n   nickname: " + this.toIndentedString((Object)this.nickname) + "\n   payeeId: " + this.toIndentedString((Object)this.payeeId) + "\n   type: " + this.toIndentedString((Object)this.type) + "\n}";
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

