/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.hibernate.annotations.GenericGenerator;

@ApiModel
@Entity
public class BankingInternationalPayeeBeneficiaryDetails {
    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid2")
    @JsonIgnore
    private String id;
    private String country;
    private String message;
    private String name;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BankingInternationalPayeeBeneficiaryDetails country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(required=true, value="Country where the beneficiary resides. A valid [ISO 3166 Alpha-3](https://www.iso.org/iso-3166-country-codes.html) country code")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public BankingInternationalPayeeBeneficiaryDetails message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(value="Response message for the payment")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public BankingInternationalPayeeBeneficiaryDetails name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name of the beneficiary")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankingInternationalPayeeBeneficiaryDetails bankingInternationalPayeeBeneficiaryDetails = (BankingInternationalPayeeBeneficiaryDetails)o;
        return Objects.equals(this.id, bankingInternationalPayeeBeneficiaryDetails.id) && Objects.equals(this.country, bankingInternationalPayeeBeneficiaryDetails.country) && Objects.equals(this.message, bankingInternationalPayeeBeneficiaryDetails.message) && Objects.equals(this.name, bankingInternationalPayeeBeneficiaryDetails.name);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.country, this.message, this.name);
    }

    public String toString() {
        return "class BankingInternationalPayeeBeneficiaryDetails {\n   id: " + this.toIndentedString((Object)this.id) + "\n   country: " + this.toIndentedString((Object)this.country) + "\n   message: " + this.toIndentedString((Object)this.message) + "\n   name: " + this.toIndentedString((Object)this.name) + "\n}";
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

