/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.format.annotation.DateTimeFormat;

@ApiModel
@Entity
public class BankingCreditCardAccount {
    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid2")
    @JsonIgnore
    private String id;
    private String minPaymentAmount;
    private String paymentCurrency;
    private String paymentDueAmount;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private LocalDate paymentDueDate;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BankingCreditCardAccount minPaymentAmount(String minPaymentAmount) {
        this.minPaymentAmount = minPaymentAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="The minimum payment amount due for the next card payment")
    public String getMinPaymentAmount() {
        return this.minPaymentAmount;
    }

    public void setMinPaymentAmount(String minPaymentAmount) {
        this.minPaymentAmount = minPaymentAmount;
    }

    public BankingCreditCardAccount paymentCurrency(String paymentCurrency) {
        this.paymentCurrency = paymentCurrency;
        return this;
    }

    @ApiModelProperty(value="If absent assumes AUD")
    public String getPaymentCurrency() {
        return this.paymentCurrency;
    }

    public void setPaymentCurrency(String paymentCurrency) {
        this.paymentCurrency = paymentCurrency;
    }

    public BankingCreditCardAccount paymentDueAmount(String paymentDueAmount) {
        this.paymentDueAmount = paymentDueAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount due for the next card payment")
    public String getPaymentDueAmount() {
        return this.paymentDueAmount;
    }

    public void setPaymentDueAmount(String paymentDueAmount) {
        this.paymentDueAmount = paymentDueAmount;
    }

    public BankingCreditCardAccount paymentDueDate(LocalDate paymentDueDate) {
        this.paymentDueDate = paymentDueDate;
        return this;
    }

    @ApiModelProperty(required=true, value="Date that the next payment for the card is due")
    public LocalDate getPaymentDueDate() {
        return this.paymentDueDate;
    }

    public void setPaymentDueDate(LocalDate paymentDueDate) {
        this.paymentDueDate = paymentDueDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankingCreditCardAccount bankingCreditCardAccount = (BankingCreditCardAccount)o;
        return Objects.equals(this.id, bankingCreditCardAccount.id) && Objects.equals(this.minPaymentAmount, bankingCreditCardAccount.minPaymentAmount) && Objects.equals(this.paymentCurrency, bankingCreditCardAccount.paymentCurrency) && Objects.equals(this.paymentDueAmount, bankingCreditCardAccount.paymentDueAmount) && Objects.equals(this.paymentDueDate, bankingCreditCardAccount.paymentDueDate);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.minPaymentAmount, this.paymentCurrency, this.paymentDueAmount, this.paymentDueDate);
    }

    public String toString() {
        return "class BankingCreditCardAccount {\n   id: " + this.toIndentedString((Object)this.id) + "\n   minPaymentAmount: " + this.toIndentedString((Object)this.minPaymentAmount) + "\n   paymentCurrency: " + this.toIndentedString((Object)this.paymentCurrency) + "\n   paymentDueAmount: " + this.toIndentedString((Object)this.paymentDueAmount) + "\n   paymentDueDate: " + this.toIndentedString((Object)this.paymentDueDate) + "\n}";
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

