/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.hibernate.annotations.GenericGenerator;

@ApiModel
@Entity
public class BankingBillerPayee {
    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid2")
    @JsonIgnore
    private String id;
    private String billerCode;
    private String billerName;
    private String crn;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BankingBillerPayee billerCode(String billerCode) {
        this.billerCode = billerCode;
        return this;
    }

    @ApiModelProperty(required=true, value="BPAY Biller Code of the Biller")
    public String getBillerCode() {
        return this.billerCode;
    }

    public void setBillerCode(String billerCode) {
        this.billerCode = billerCode;
    }

    public BankingBillerPayee billerName(String billerName) {
        this.billerName = billerName;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the Biller")
    public String getBillerName() {
        return this.billerName;
    }

    public void setBillerName(String billerName) {
        this.billerName = billerName;
    }

    public BankingBillerPayee crn(String crn) {
        this.crn = crn;
        return this;
    }

    @ApiModelProperty(value="BPAY CRN of the Biller. If the contents of the CRN match the format of a Credit Card PAN then it should be masked using the rules applicable for the MaskedPANString common type")
    public String getCrn() {
        return this.crn;
    }

    public void setCrn(String crn) {
        this.crn = crn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankingBillerPayee bankingBillerPayee = (BankingBillerPayee)o;
        return Objects.equals(this.id, bankingBillerPayee.id) && Objects.equals(this.billerCode, bankingBillerPayee.billerCode) && Objects.equals(this.billerName, bankingBillerPayee.billerName) && Objects.equals(this.crn, bankingBillerPayee.crn);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.billerCode, this.billerName, this.crn);
    }

    public String toString() {
        return "class BankingBillerPayee {\n   id: " + this.toIndentedString((Object)this.id) + "\n   billerCode: " + this.toIndentedString((Object)this.billerCode) + "\n   billerName: " + this.toIndentedString((Object)this.billerName) + "\n   crn: " + this.toIndentedString((Object)this.crn) + "\n}";
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

