/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.model;

import au.org.consumerdatastandards.holder.model.BankingAccount;
import au.org.consumerdatastandards.holder.model.BankingBalancePurse;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.hibernate.annotations.GenericGenerator;

@ApiModel
@Entity
public class BankingBalance {
    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid2")
    @JsonIgnore
    private String id;
    private String accountId;
    @JsonIgnore
    @ManyToOne
    @JoinColumn(updatable=false)
    private BankingAccount bankingAccount;
    private String amortisedLimit;
    private String availableBalance;
    private String creditLimit;
    private String currency;
    private String currentBalance;
    @OneToMany
    @JoinTable(name="banking_balance_purses", joinColumns={@JoinColumn(name="banking_balance_id")}, inverseJoinColumns={@JoinColumn(name="purse_id")})
    private List<BankingBalancePurse> purses;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BankingBalance accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique ID of the account adhering to the standards for ID permanence")
    public String getAccountId() {
        return this.accountId;
    }

    public BankingAccount getBankingAccount() {
        return this.bankingAccount;
    }

    public void setBankingAccount(BankingAccount bankingAccount) {
        this.bankingAccount = bankingAccount;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public BankingBalance amortisedLimit(String amortisedLimit) {
        this.amortisedLimit = amortisedLimit;
        return this;
    }

    @ApiModelProperty(value="Object representing the available limit amortised according to payment schedule. Assumed to be zero if absent")
    public String getAmortisedLimit() {
        return this.amortisedLimit;
    }

    public void setAmortisedLimit(String amortisedLimit) {
        this.amortisedLimit = amortisedLimit;
    }

    public BankingBalance availableBalance(String availableBalance) {
        this.availableBalance = availableBalance;
        return this;
    }

    @ApiModelProperty(required=true, value="Balance representing the amount of funds available for transfer. Assumed to be zero or positive")
    public String getAvailableBalance() {
        return this.availableBalance;
    }

    public void setAvailableBalance(String availableBalance) {
        this.availableBalance = availableBalance;
    }

    public BankingBalance creditLimit(String creditLimit) {
        this.creditLimit = creditLimit;
        return this;
    }

    @ApiModelProperty(value="Object representing the maximum amount of credit that is available for this account. Assumed to be zero if absent")
    public String getCreditLimit() {
        return this.creditLimit;
    }

    public void setCreditLimit(String creditLimit) {
        this.creditLimit = creditLimit;
    }

    public BankingBalance currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(value="The currency for the balance amounts. If absent assumed to be AUD")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public BankingBalance currentBalance(String currentBalance) {
        this.currentBalance = currentBalance;
        return this;
    }

    @ApiModelProperty(required=true, value="The balance of the account at this time. Should align to the balance available via other channels such as Internet Banking. Assumed to be negative if the customer has money owing")
    public String getCurrentBalance() {
        return this.currentBalance;
    }

    public void setCurrentBalance(String currentBalance) {
        this.currentBalance = currentBalance;
    }

    public BankingBalance purses(List<BankingBalancePurse> purses) {
        this.purses = purses;
        return this;
    }

    public BankingBalance addItem(BankingBalancePurse pursesItem) {
        if (this.purses == null) {
            this.purses = new ArrayList();
        }
        this.purses.add(pursesItem);
        return this;
    }

    @ApiModelProperty(value="Optional array of balances for the account in other currencies. Included to support accounts that support multi-currency purses such as Travel Cards")
    public List<BankingBalancePurse> getPurses() {
        return this.purses;
    }

    public void setPurses(List<BankingBalancePurse> purses) {
        this.purses = purses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankingBalance bankingBalance = (BankingBalance)o;
        return Objects.equals(this.id, bankingBalance.id) && Objects.equals(this.accountId, bankingBalance.accountId) && Objects.equals(this.amortisedLimit, bankingBalance.amortisedLimit) && Objects.equals(this.availableBalance, bankingBalance.availableBalance) && Objects.equals(this.creditLimit, bankingBalance.creditLimit) && Objects.equals(this.currency, bankingBalance.currency) && Objects.equals(this.currentBalance, bankingBalance.currentBalance) && Objects.equals(this.purses, bankingBalance.purses);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.accountId, this.amortisedLimit, this.availableBalance, this.creditLimit, this.currency, this.currentBalance, this.purses);
    }

    public String toString() {
        return "class BankingBalance {\n   id: " + this.toIndentedString((Object)this.id) + "\n   accountId: " + this.toIndentedString((Object)this.accountId) + "\n   amortisedLimit: " + this.toIndentedString((Object)this.amortisedLimit) + "\n   availableBalance: " + this.toIndentedString((Object)this.availableBalance) + "\n   creditLimit: " + this.toIndentedString((Object)this.creditLimit) + "\n   currency: " + this.toIndentedString((Object)this.currency) + "\n   currentBalance: " + this.toIndentedString((Object)this.currentBalance) + "\n   purses: " + this.toIndentedString((Object)this.purses) + "\n}";
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

