/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.api;

import au.org.consumerdatastandards.holder.api.ApiControllerBase;
import au.org.consumerdatastandards.holder.api.BankingProductsApi;
import au.org.consumerdatastandards.holder.model.BankingProduct;
import au.org.consumerdatastandards.holder.model.BankingProductCategory;
import au.org.consumerdatastandards.holder.model.BankingProductDetail;
import au.org.consumerdatastandards.holder.model.BankingProductV2;
import au.org.consumerdatastandards.holder.model.Links;
import au.org.consumerdatastandards.holder.model.ParamEffective;
import au.org.consumerdatastandards.holder.model.ResponseBankingProductById;
import au.org.consumerdatastandards.holder.model.ResponseBankingProductList;
import au.org.consumerdatastandards.holder.model.ResponseBankingProductListData;
import au.org.consumerdatastandards.holder.service.BankingProductService;
import au.org.consumerdatastandards.holder.util.WebUtil;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.request.NativeWebRequest;

@Validated
@Controller
@RequestMapping(value={"${openapi.consumerDataStandards.base-path:/cds-au/v1}"})
public class BankingProductsApiController
extends ApiControllerBase
implements BankingProductsApi {
    private final BankingProductService service;
    private final NativeWebRequest request;

    @Autowired
    public BankingProductsApiController(NativeWebRequest request, BankingProductService service) {
        this.request = request;
        this.service = service;
    }

    public Optional<NativeWebRequest> getRequest() {
        return Optional.ofNullable(this.request);
    }

    public ResponseEntity<ResponseBankingProductById> getProductDetail(String productId, Integer xMinV, Integer xV) {
        this.validateHeaders(xMinV, xV);
        HttpHeaders headers = this.generateResponseHeaders(this.request);
        BankingProductDetail productDetail = this.service.getProductDetail(productId, this.getSupportedVersion(xMinV, xV));
        if (productDetail == null) {
            return new ResponseEntity(null, (MultiValueMap)headers, HttpStatus.NOT_FOUND);
        }
        ResponseBankingProductById responseProductById = new ResponseBankingProductById();
        responseProductById.setData(productDetail);
        responseProductById.setLinks(new Links());
        responseProductById.getLinks().setSelf(WebUtil.getOriginalUrl((NativeWebRequest)this.request));
        this.logger.info("Found product id of {} and returning formatted response", (Object)productId);
        this.logger.debug("Detail product response is: {}", (Object)responseProductById);
        return new ResponseEntity((Object)responseProductById, (MultiValueMap)headers, HttpStatus.OK);
    }

    public ResponseEntity<ResponseBankingProductList> listProducts(ParamEffective effective, OffsetDateTime updatedSince, String brand, BankingProductCategory productCategory, Integer page, Integer pageSize, Integer xMinV, Integer xV) {
        this.logger.info("Initiating product list call with supplied input of effective from {}, updated since {}, brand of {}, product category of {} for page {} with page size of {}", new Object[]{effective, updatedSince, brand, productCategory, page, pageSize});
        this.validateHeaders(xMinV, xV);
        this.validatePageInputs(page, pageSize);
        HttpHeaders headers = this.generateResponseHeaders(this.request);
        BankingProductV2 bankingProduct = new BankingProductV2();
        bankingProduct.setLastUpdated(updatedSince);
        bankingProduct.setBrand(brand);
        if (productCategory != null) {
            bankingProduct.setProductCategory(BankingProductCategory.valueOf((String)productCategory.name()));
        }
        Integer actualPage = this.getPagingValue(page, 1);
        Integer actualPageSize = this.getPagingValue(pageSize, 25);
        Page productsPage = this.service.findProductsLike(effective, (BankingProduct)bankingProduct, (Pageable)PageRequest.of((int)(actualPage - 1), (int)actualPageSize), this.getSupportedVersion(xMinV, xV));
        this.logger.info("Returning basic product listing page {} of {} (page size of {}) using filters of effective {}, updated since {}, brand {}, product category of {}", new Object[]{actualPage, productsPage.getTotalPages(), actualPageSize, effective, updatedSince, brand, productCategory});
        ResponseBankingProductListData listData = new ResponseBankingProductListData();
        listData.setProducts(productsPage.getContent());
        this.logger.info("Products Page data set to isFirst: {}, isLast: {}", (Object)productsPage.isFirst(), (Object)productsPage.isLast());
        ResponseBankingProductList responseProductList = new ResponseBankingProductList();
        responseProductList.setData(listData);
        responseProductList.setLinks(this.getLinkData(this.request, productsPage, actualPage, actualPageSize));
        responseProductList.setMeta(this.getMetaData(productsPage));
        this.logger.debug("Product listing raw response payload is: {}", (Object)responseProductList);
        return new ResponseEntity((Object)responseProductList, (MultiValueMap)headers, HttpStatus.OK);
    }

    protected Integer getCurrentVersion() {
        return 3;
    }
}

