/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.service;

import au.org.consumerdatastandards.holder.model.BankingProductCategory;
import au.org.consumerdatastandards.holder.model.BankingScheduledPayment;
import au.org.consumerdatastandards.holder.model.BankingScheduledPaymentFrom;
import au.org.consumerdatastandards.holder.model.ParamAccountOpenStatus;
import au.org.consumerdatastandards.holder.repository.BankingScheduledPaymentRepository;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class BankingScheduledPaymentService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BankingScheduledPaymentService.class);
    private final BankingScheduledPaymentRepository bankingScheduledPaymentRepository;

    @Autowired
    public BankingScheduledPaymentService(BankingScheduledPaymentRepository bankingScheduledPaymentRepository) {
        this.bankingScheduledPaymentRepository = bankingScheduledPaymentRepository;
    }

    public Page<BankingScheduledPayment> getBankingScheduledPayments(String accountId, Pageable pageable) {
        LOGGER.debug("Retrieving banking scheduled payments by account id {}", (Object)accountId);
        BankingScheduledPaymentFrom from = new BankingScheduledPaymentFrom().accountId(accountId);
        return this.bankingScheduledPaymentRepository.findByFrom(from, pageable);
    }

    public Page<BankingScheduledPayment> getBankingScheduledPayments(List<String> accountIds, Pageable pageable) {
        LOGGER.debug("Retrieving banking scheduled payments by account ids {}", accountIds);
        return this.bankingScheduledPaymentRepository.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(root.get("from").get("accountId").in((Collection)accountIds));
            return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
        }, pageable);
    }

    public Page<BankingScheduledPayment> getBankingScheduledPayments(BankingProductCategory productCategory, ParamAccountOpenStatus openStatus, Boolean isOwned, Pageable pageable) {
        LOGGER.debug("Retrieving {} banking scheduled payments by product category {}, open status {}", new Object[]{isOwned != null && isOwned != false ? "owned" : "all", productCategory, openStatus});
        return this.bankingScheduledPaymentRepository.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(criteriaBuilder.equal((Expression)root.get("from").get("bankingAccount").get("productCategory"), (Object)productCategory));
            if (!ParamAccountOpenStatus.ALL.equals((Object)openStatus)) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("from").get("bankingAccount").get("openStatus"), (Object)openStatus));
            }
            return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
        }, pageable);
    }
}

