/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.service;

import au.org.consumerdatastandards.holder.model.BankingPayee;
import au.org.consumerdatastandards.holder.model.BankingPayeeDetail;
import au.org.consumerdatastandards.holder.repository.BankingPayeeDetailRepository;
import au.org.consumerdatastandards.holder.repository.BankingPayeeRepository;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class BankingPayeeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BankingPayeeService.class);
    private final BankingPayeeRepository bankingPayeeRepository;
    private final BankingPayeeDetailRepository bankingPayeeDetailRepository;

    @Autowired
    public BankingPayeeService(BankingPayeeRepository bankingPayeeRepository, BankingPayeeDetailRepository bankingPayeeDetailRepository) {
        this.bankingPayeeRepository = bankingPayeeRepository;
        this.bankingPayeeDetailRepository = bankingPayeeDetailRepository;
    }

    public BankingPayeeDetail getBankingPayeeDetail(String payeeId) {
        LOGGER.debug("Retrieving banking payee detail by payee id {}", (Object)payeeId);
        Optional byId = this.bankingPayeeDetailRepository.findById((Object)payeeId);
        return byId.orElse(null);
    }

    public Page<BankingPayee> getBankingPayees(BankingPayee.Type type, Pageable pageable) {
        LOGGER.debug("Retrieving banking payees by type {}", (Object)type);
        if (type == null) {
            return this.bankingPayeeRepository.findAll(pageable);
        }
        return this.bankingPayeeRepository.findByType(type, pageable);
    }
}

