/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.service;

import au.org.consumerdatastandards.holder.model.BankingAccount;
import au.org.consumerdatastandards.holder.model.BankingDirectDebit;
import au.org.consumerdatastandards.holder.model.BankingProductCategory;
import au.org.consumerdatastandards.holder.repository.BankingDirectDebitRepository;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class BankingDirectDebitService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BankingDirectDebitService.class);
    private final BankingDirectDebitRepository bankingDirectDebitRepository;

    @Autowired
    public BankingDirectDebitService(BankingDirectDebitRepository bankingDirectDebitRepository) {
        this.bankingDirectDebitRepository = bankingDirectDebitRepository;
    }

    public Page<BankingDirectDebit> getBankingDirectDebits(String accountId, Pageable pageable) {
        LOGGER.debug("Retrieving banking direct debits by account id {}", (Object)accountId);
        return this.bankingDirectDebitRepository.findByAccountId(accountId, pageable);
    }

    public Page<BankingDirectDebit> getBankingDirectDebits(Boolean isOwned, BankingProductCategory category, BankingAccount.OpenStatus openStatus, Pageable pageable) {
        LOGGER.debug("Retrieving {} banking direct-debits matching product category {} and open status {} with Paging content specified as {}", new Object[]{isOwned != null && isOwned != false ? "owned" : "all", category, openStatus, pageable});
        return this.bankingDirectDebitRepository.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (category != null) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("bankingAccount").get("productCategory"), (Object)category));
            }
            if (openStatus != null) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("bankingAccount").get("openStatus"), (Object)openStatus));
            }
            return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
        }, pageable);
    }

    public Page<BankingDirectDebit> getBankingDirectDebits(List<String> accountIds, Pageable pageable) {
        LOGGER.debug("Retrieving banking direct debits by account ids {}", accountIds);
        return this.bankingDirectDebitRepository.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(root.get("accountId").in((Collection)accountIds));
            return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
        }, pageable);
    }
}

