/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.service;

import au.org.consumerdatastandards.holder.model.BankingAccount;
import au.org.consumerdatastandards.holder.model.BankingAccountDetail;
import au.org.consumerdatastandards.holder.model.BankingBalance;
import au.org.consumerdatastandards.holder.model.BankingProductCategory;
import au.org.consumerdatastandards.holder.repository.BankingAccountDetailRepository;
import au.org.consumerdatastandards.holder.repository.BankingAccountRepository;
import au.org.consumerdatastandards.holder.repository.BankingBalanceRepository;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class BankingAccountService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BankingAccountService.class);
    private final BankingAccountRepository bankingAccountRepository;
    private final BankingAccountDetailRepository bankingAccountDetailRepository;
    private final BankingBalanceRepository bankingBalanceRepository;

    @Autowired
    public BankingAccountService(BankingAccountRepository bankingAccountRepository, BankingAccountDetailRepository bankingAccountDetailRepository, BankingBalanceRepository bankingBalanceRepository) {
        this.bankingAccountRepository = bankingAccountRepository;
        this.bankingAccountDetailRepository = bankingAccountDetailRepository;
        this.bankingBalanceRepository = bankingBalanceRepository;
    }

    public BankingAccountDetail getBankingAccountDetail(String accountId) {
        LOGGER.debug("Retrieving account detail by id {}", (Object)accountId);
        Optional byId = this.bankingAccountDetailRepository.findById((Object)accountId);
        return byId.orElse(null);
    }

    public Page<BankingAccount> findBankingAccountsLike(Boolean isOwned, BankingAccount bankingAccount, Pageable pageable) {
        LOGGER.debug("Retrieve {} accounts like BankingAccount specified as {} with Paging content specified as {}", new Object[]{isOwned != null && isOwned != false ? "owned" : "all", bankingAccount, pageable});
        return this.bankingAccountRepository.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (bankingAccount.getProductCategory() != null) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("productCategory"), (Object)bankingAccount.getProductCategory()));
            }
            if (bankingAccount.getOpenStatus() != null) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("openStatus"), (Object)bankingAccount.getOpenStatus()));
            }
            return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
        }, pageable);
    }

    public BankingBalance getBankingBalance(String accountId) {
        LOGGER.debug("Retrieving banking balance for account id {}", (Object)accountId);
        return this.bankingBalanceRepository.findByAccountId(accountId);
    }

    public Page<BankingBalance> getBankingBalances(Boolean isOwned, BankingProductCategory category, BankingAccount.OpenStatus openStatus, Pageable pageable) {
        LOGGER.debug("Retrieving {} banking balance matching product category {} and open status {} with Paging content specified as {}", new Object[]{isOwned != null && isOwned != false ? "owned" : "all", category, openStatus, pageable});
        return this.bankingBalanceRepository.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (category != null) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("bankingAccount").get("productCategory"), (Object)category));
            }
            if (openStatus != null) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("bankingAccount").get("openStatus"), (Object)openStatus));
            }
            return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
        }, pageable);
    }

    public Page<BankingBalance> getBankingBalances(List<String> accountIds, Pageable pageable) {
        LOGGER.debug("Retrieving banking balance for account ids {}", accountIds);
        return this.bankingBalanceRepository.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(root.get("accountId").in((Collection)accountIds));
            return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
        }, pageable);
    }
}

