/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.model;

import au.org.consumerdatastandards.holder.model.ResponseCommonDiscoveryStatusData;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel
public class ResponseCommonDiscoveryStatusData {
    private OffsetDateTime detectionTime;
    private OffsetDateTime expectedResolutionTime;
    private String explanation;
    private Status status;
    private OffsetDateTime updateTime;

    public ResponseCommonDiscoveryStatusData detectionTime(OffsetDateTime detectionTime) {
        this.detectionTime = detectionTime;
        return this;
    }

    @ApiModelProperty(value="The date and time that the current outage was detected. Should only be present if the status property is PARTIAL_FAILURE or UNAVAILABLE")
    public OffsetDateTime getDetectionTime() {
        return this.detectionTime;
    }

    public void setDetectionTime(OffsetDateTime detectionTime) {
        this.detectionTime = detectionTime;
    }

    public ResponseCommonDiscoveryStatusData expectedResolutionTime(OffsetDateTime expectedResolutionTime) {
        this.expectedResolutionTime = expectedResolutionTime;
        return this;
    }

    @ApiModelProperty(value="The date and time that full service is expected to resume (if known). Should not be present if the status property has a value of OK.")
    public OffsetDateTime getExpectedResolutionTime() {
        return this.expectedResolutionTime;
    }

    public void setExpectedResolutionTime(OffsetDateTime expectedResolutionTime) {
        this.expectedResolutionTime = expectedResolutionTime;
    }

    public ResponseCommonDiscoveryStatusData explanation(String explanation) {
        this.explanation = explanation;
        return this;
    }

    @ApiModelProperty(value="Provides an explanation of the current outage that can be displayed to an end customer. Mandatory if the status property is any value other than OK")
    public String getExplanation() {
        return this.explanation;
    }

    public void setExplanation(String explanation) {
        this.explanation = explanation;
    }

    public ResponseCommonDiscoveryStatusData status(Status status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true)
    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public ResponseCommonDiscoveryStatusData updateTime(OffsetDateTime updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    @ApiModelProperty(required=true, value="The date and time that this status was last updated by the Data Holder.")
    public OffsetDateTime getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(OffsetDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseCommonDiscoveryStatusData responseCommonDiscoveryStatusData = (ResponseCommonDiscoveryStatusData)o;
        return Objects.equals(this.detectionTime, responseCommonDiscoveryStatusData.detectionTime) && Objects.equals(this.expectedResolutionTime, responseCommonDiscoveryStatusData.expectedResolutionTime) && Objects.equals(this.explanation, responseCommonDiscoveryStatusData.explanation) && Objects.equals(this.status, responseCommonDiscoveryStatusData.status) && Objects.equals(this.updateTime, responseCommonDiscoveryStatusData.updateTime);
    }

    public int hashCode() {
        return Objects.hash(this.detectionTime, this.expectedResolutionTime, this.explanation, this.status, this.updateTime);
    }

    public String toString() {
        return "class CommonDiscoveryStatusData {\n   detectionTime: " + this.toIndentedString((Object)this.detectionTime) + "\n   expectedResolutionTime: " + this.toIndentedString((Object)this.expectedResolutionTime) + "\n   explanation: " + this.toIndentedString((Object)this.explanation) + "\n   status: " + this.toIndentedString((Object)this.status) + "\n   updateTime: " + this.toIndentedString((Object)this.updateTime) + "\n}";
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

