/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.model;

import au.org.consumerdatastandards.holder.model.CommonPhoneNumber;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.hibernate.annotations.GenericGenerator;

@ApiModel
@Entity
public class CommonPhoneNumber {
    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid2")
    @JsonIgnore
    private String id;
    private String areaCode;
    private String countryCode;
    private String extension;
    private String fullNumber;
    private Boolean isPreferred;
    private String number;
    private Purpose purpose;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CommonPhoneNumber areaCode(String areaCode) {
        this.areaCode = areaCode;
        return this;
    }

    @ApiModelProperty(value="Required for non Mobile Phones, if field is present and refers to Australian code - the leading 0 should be omitted.")
    public String getAreaCode() {
        return this.areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public CommonPhoneNumber countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @ApiModelProperty(value="If absent, assumed to be Australia (+61). The + should be included")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public CommonPhoneNumber extension(String extension) {
        this.extension = extension;
        return this;
    }

    @ApiModelProperty(value="An extension number (if applicable)")
    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public CommonPhoneNumber fullNumber(String fullNumber) {
        this.fullNumber = fullNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="Fully formatted phone number with country code, area code, number and extension incorporated. Formatted according to section 5.1.4. of [RFC 3966](https://www.ietf.org/rfc/rfc3966.txt)")
    public String getFullNumber() {
        return this.fullNumber;
    }

    public void setFullNumber(String fullNumber) {
        this.fullNumber = fullNumber;
    }

    public CommonPhoneNumber isPreferred(Boolean isPreferred) {
        this.isPreferred = isPreferred;
        return this;
    }

    @ApiModelProperty(value="May be true for one and only one entry to indicate the preferred phone number. Assumed to be 'false' if not present")
    public Boolean getIsPreferred() {
        return this.isPreferred;
    }

    public void setIsPreferred(Boolean isPreferred) {
        this.isPreferred = isPreferred;
    }

    public CommonPhoneNumber number(String number) {
        this.number = number;
        return this;
    }

    @ApiModelProperty(required=true, value="The actual phone number, with leading zeros as appropriate")
    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public CommonPhoneNumber purpose(Purpose purpose) {
        this.purpose = purpose;
        return this;
    }

    @ApiModelProperty(required=true)
    public Purpose getPurpose() {
        return this.purpose;
    }

    public void setPurpose(Purpose purpose) {
        this.purpose = purpose;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommonPhoneNumber commonPhoneNumber = (CommonPhoneNumber)o;
        return Objects.equals(this.id, commonPhoneNumber.id) && Objects.equals(this.areaCode, commonPhoneNumber.areaCode) && Objects.equals(this.countryCode, commonPhoneNumber.countryCode) && Objects.equals(this.extension, commonPhoneNumber.extension) && Objects.equals(this.fullNumber, commonPhoneNumber.fullNumber) && Objects.equals(this.isPreferred, commonPhoneNumber.isPreferred) && Objects.equals(this.number, commonPhoneNumber.number) && Objects.equals(this.purpose, commonPhoneNumber.purpose);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.areaCode, this.countryCode, this.extension, this.fullNumber, this.isPreferred, this.number, this.purpose);
    }

    public String toString() {
        return "class CommonPhoneNumber {\n   id: " + this.toIndentedString((Object)this.id) + "\n   areaCode: " + this.toIndentedString((Object)this.areaCode) + "\n   countryCode: " + this.toIndentedString((Object)this.countryCode) + "\n   extension: " + this.toIndentedString((Object)this.extension) + "\n   fullNumber: " + this.toIndentedString((Object)this.fullNumber) + "\n   isPreferred: " + this.toIndentedString((Object)this.isPreferred) + "\n   number: " + this.toIndentedString((Object)this.number) + "\n   purpose: " + this.toIndentedString((Object)this.purpose) + "\n}";
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

