/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;

@ApiModel
@Entity
@Table(name="CommonPerson")
public class CommonPerson {
    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid2")
    @JsonIgnore
    private String id;
    private String firstName;
    private String lastName;
    private OffsetDateTime lastUpdateTime;
    @ElementCollection
    private List<String> middleNames;
    private String occupationCode;
    private String prefix;
    private String suffix;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CommonPerson firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @ApiModelProperty(value="For people with single names this field need not be present.  The single name should be in the lastName field")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public CommonPerson lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @ApiModelProperty(required=true, value="For people with single names the single name should be in this field")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public CommonPerson lastUpdateTime(OffsetDateTime lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
        return this;
    }

    @ApiModelProperty(value="The date and time that this record was last updated by the customer.  If no update has occurred then this date should reflect the initial creation date for the data")
    public OffsetDateTime getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(OffsetDateTime lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public CommonPerson middleNames(List<String> middleNames) {
        this.middleNames = middleNames;
        return this;
    }

    public CommonPerson addItem(String middleNamesItem) {
        this.middleNames.add(middleNamesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Field is mandatory but array may be empty")
    public List<String> getMiddleNames() {
        return this.middleNames;
    }

    public void setMiddleNames(List<String> middleNames) {
        this.middleNames = middleNames;
    }

    public CommonPerson occupationCode(String occupationCode) {
        this.occupationCode = occupationCode;
        return this;
    }

    @ApiModelProperty(value="Value is a valid [ANZCO v1.2](http://www.abs.gov.au/ANZSCO) Standard Occupation classification.")
    public String getOccupationCode() {
        return this.occupationCode;
    }

    public void setOccupationCode(String occupationCode) {
        this.occupationCode = occupationCode;
    }

    public CommonPerson prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @ApiModelProperty(value="Also known as title or salutation.  The prefix to the name (e.g. Mr, Mrs, Ms, Miss, Sir, etc)")
    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public CommonPerson suffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    @ApiModelProperty(value="Used for a trailing suffix to the name (e.g. Jr)")
    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommonPerson commonPerson = (CommonPerson)o;
        return Objects.equals(this.id, commonPerson.id) && Objects.equals(this.firstName, commonPerson.firstName) && Objects.equals(this.lastName, commonPerson.lastName) && Objects.equals(this.lastUpdateTime, commonPerson.lastUpdateTime) && Objects.equals(this.middleNames, commonPerson.middleNames) && Objects.equals(this.occupationCode, commonPerson.occupationCode) && Objects.equals(this.prefix, commonPerson.prefix) && Objects.equals(this.suffix, commonPerson.suffix);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.firstName, this.lastName, this.lastUpdateTime, this.middleNames, this.occupationCode, this.prefix, this.suffix);
    }

    public String toString() {
        return "class CommonPerson {\n   id: " + this.toIndentedString((Object)this.id) + "\n   firstName: " + this.toIndentedString((Object)this.firstName) + "\n   lastName: " + this.toIndentedString((Object)this.lastName) + "\n   lastUpdateTime: " + this.toIndentedString((Object)this.lastUpdateTime) + "\n   middleNames: " + this.toIndentedString((Object)this.middleNames) + "\n   occupationCode: " + this.toIndentedString((Object)this.occupationCode) + "\n   prefix: " + this.toIndentedString((Object)this.prefix) + "\n   suffix: " + this.toIndentedString((Object)this.suffix) + "\n}";
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

