/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.model;

import au.org.consumerdatastandards.holder.model.CommonEmailAddress;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.hibernate.annotations.GenericGenerator;

@ApiModel
@Entity
public class CommonEmailAddress {
    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid2")
    @JsonIgnore
    private String id;
    private String address;
    private Boolean isPreferred;
    private Purpose purpose;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CommonEmailAddress address(String address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(required=true, value="A correctly formatted email address, as defined by the addr_spec format in [RFC 5322](https://www.ietf.org/rfc/rfc5322.txt)")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public CommonEmailAddress isPreferred(Boolean isPreferred) {
        this.isPreferred = isPreferred;
        return this;
    }

    @ApiModelProperty(value="May be true for one and only one email record in the collection. Denotes the default email address")
    public Boolean getIsPreferred() {
        return this.isPreferred;
    }

    public void setIsPreferred(Boolean isPreferred) {
        this.isPreferred = isPreferred;
    }

    public CommonEmailAddress purpose(Purpose purpose) {
        this.purpose = purpose;
        return this;
    }

    @ApiModelProperty(required=true)
    public Purpose getPurpose() {
        return this.purpose;
    }

    public void setPurpose(Purpose purpose) {
        this.purpose = purpose;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommonEmailAddress commonEmailAddress = (CommonEmailAddress)o;
        return Objects.equals(this.id, commonEmailAddress.id) && Objects.equals(this.address, commonEmailAddress.address) && Objects.equals(this.isPreferred, commonEmailAddress.isPreferred) && Objects.equals(this.purpose, commonEmailAddress.purpose);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.address, this.isPreferred, this.purpose);
    }

    public String toString() {
        return "class CommonEmailAddress {\n   id: " + this.toIndentedString((Object)this.id) + "\n   address: " + this.toIndentedString((Object)this.address) + "\n   isPreferred: " + this.toIndentedString((Object)this.isPreferred) + "\n   purpose: " + this.toIndentedString((Object)this.purpose) + "\n}";
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

