/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.model;

import au.org.consumerdatastandards.holder.model.BankingScheduledPaymentTo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import org.hibernate.annotations.GenericGenerator;

@ApiModel(description="The set of payment amounts and destination accounts for this payment accommodating multi-part payments. A single entry indicates a simple payment with one destination account. Must have at least one entry")
@Entity
public class BankingScheduledPaymentSet {
    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid2")
    @JsonIgnore
    private String id;
    private String amount;
    private String currency;
    private Boolean isAmountCalculated;
    @ManyToOne
    private BankingScheduledPaymentTo to;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BankingScheduledPaymentSet amount(String amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="Flag indicating whether the amount of the payment is calculated based on the context of the event. For instance a payment to reduce the balance of a credit card to zero. If absent then false is assumed")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public BankingScheduledPaymentSet currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(value="The currency for the payment. AUD assumed if not present")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public BankingScheduledPaymentSet isAmountCalculated(Boolean isAmountCalculated) {
        this.isAmountCalculated = isAmountCalculated;
        return this;
    }

    @ApiModelProperty(value="Flag indicating whether the amount of the payment is calculated based on the context of the event. For instance a payment to reduce the balance of a credit card to zero. If absent then false is assumed")
    public Boolean getIsAmountCalculated() {
        return this.isAmountCalculated;
    }

    public void setIsAmountCalculated(Boolean isAmountCalculated) {
        this.isAmountCalculated = isAmountCalculated;
    }

    public BankingScheduledPaymentSet to(BankingScheduledPaymentTo to) {
        this.to = to;
        return this;
    }

    @ApiModelProperty(required=true)
    public BankingScheduledPaymentTo getTo() {
        return this.to;
    }

    public void setTo(BankingScheduledPaymentTo to) {
        this.to = to;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankingScheduledPaymentSet bankingScheduledPaymentSet = (BankingScheduledPaymentSet)o;
        return Objects.equals(this.id, bankingScheduledPaymentSet.id) && Objects.equals(this.amount, bankingScheduledPaymentSet.amount) && Objects.equals(this.currency, bankingScheduledPaymentSet.currency) && Objects.equals(this.isAmountCalculated, bankingScheduledPaymentSet.isAmountCalculated) && Objects.equals(this.to, bankingScheduledPaymentSet.to);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.amount, this.currency, this.isAmountCalculated, this.to);
    }

    public String toString() {
        return "class BankingScheduledPaymentSet {\n   id: " + this.toIndentedString((Object)this.id) + "\n   amount: " + this.toIndentedString((Object)this.amount) + "\n   currency: " + this.toIndentedString((Object)this.currency) + "\n   isAmountCalculated: " + this.toIndentedString((Object)this.isAmountCalculated) + "\n   to: " + this.toIndentedString((Object)this.to) + "\n}";
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

