/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.model;

import au.org.consumerdatastandards.holder.model.BankingScheduledPaymentRecurrence;
import au.org.consumerdatastandards.holder.model.BankingScheduledPaymentRecurrenceEventBased;
import au.org.consumerdatastandards.holder.model.BankingScheduledPaymentRecurrenceIntervalSchedule;
import au.org.consumerdatastandards.holder.model.BankingScheduledPaymentRecurrenceLastWeekday;
import au.org.consumerdatastandards.holder.model.BankingScheduledPaymentRecurrenceOnceOff;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.format.annotation.DateTimeFormat;

@ApiModel(description="Object containing the detail of the schedule for the payment")
@Entity
public class BankingScheduledPaymentRecurrence {
    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid2")
    @JsonIgnore
    private String id;
    @Embedded
    private BankingScheduledPaymentRecurrenceEventBased eventBased;
    @ManyToOne
    private BankingScheduledPaymentRecurrenceIntervalSchedule intervalSchedule;
    @Embedded
    private BankingScheduledPaymentRecurrenceLastWeekday lastWeekDay;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private LocalDate nextPaymentDate;
    @Embedded
    private BankingScheduledPaymentRecurrenceOnceOff onceOff;
    private RecurrenceUType recurrenceUType;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BankingScheduledPaymentRecurrence eventBased(BankingScheduledPaymentRecurrenceEventBased eventBased) {
        this.eventBased = eventBased;
        return this;
    }

    @ApiModelProperty
    public BankingScheduledPaymentRecurrenceEventBased getEventBased() {
        return this.eventBased;
    }

    public void setEventBased(BankingScheduledPaymentRecurrenceEventBased eventBased) {
        this.eventBased = eventBased;
    }

    public BankingScheduledPaymentRecurrence intervalSchedule(BankingScheduledPaymentRecurrenceIntervalSchedule intervalSchedule) {
        this.intervalSchedule = intervalSchedule;
        return this;
    }

    @ApiModelProperty
    public BankingScheduledPaymentRecurrenceIntervalSchedule getIntervalSchedule() {
        return this.intervalSchedule;
    }

    public void setIntervalSchedule(BankingScheduledPaymentRecurrenceIntervalSchedule intervalSchedule) {
        this.intervalSchedule = intervalSchedule;
    }

    public BankingScheduledPaymentRecurrence lastWeekDay(BankingScheduledPaymentRecurrenceLastWeekday lastWeekDay) {
        this.lastWeekDay = lastWeekDay;
        return this;
    }

    @ApiModelProperty
    public BankingScheduledPaymentRecurrenceLastWeekday getLastWeekDay() {
        return this.lastWeekDay;
    }

    public void setLastWeekDay(BankingScheduledPaymentRecurrenceLastWeekday lastWeekDay) {
        this.lastWeekDay = lastWeekDay;
    }

    public BankingScheduledPaymentRecurrence nextPaymentDate(LocalDate nextPaymentDate) {
        this.nextPaymentDate = nextPaymentDate;
        return this;
    }

    @ApiModelProperty(value="The date of the next payment under the recurrence schedule")
    public LocalDate getNextPaymentDate() {
        return this.nextPaymentDate;
    }

    public void setNextPaymentDate(LocalDate nextPaymentDate) {
        this.nextPaymentDate = nextPaymentDate;
    }

    public BankingScheduledPaymentRecurrence onceOff(BankingScheduledPaymentRecurrenceOnceOff onceOff) {
        this.onceOff = onceOff;
        return this;
    }

    @ApiModelProperty
    public BankingScheduledPaymentRecurrenceOnceOff getOnceOff() {
        return this.onceOff;
    }

    public void setOnceOff(BankingScheduledPaymentRecurrenceOnceOff onceOff) {
        this.onceOff = onceOff;
    }

    public BankingScheduledPaymentRecurrence recurrenceUType(RecurrenceUType recurrenceUType) {
        this.recurrenceUType = recurrenceUType;
        return this;
    }

    @ApiModelProperty(required=true)
    public RecurrenceUType getRecurrenceUType() {
        return this.recurrenceUType;
    }

    public void setRecurrenceUType(RecurrenceUType recurrenceUType) {
        this.recurrenceUType = recurrenceUType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankingScheduledPaymentRecurrence bankingScheduledPaymentRecurrence = (BankingScheduledPaymentRecurrence)o;
        return Objects.equals(this.id, bankingScheduledPaymentRecurrence.id) && Objects.equals(this.eventBased, bankingScheduledPaymentRecurrence.eventBased) && Objects.equals(this.intervalSchedule, bankingScheduledPaymentRecurrence.intervalSchedule) && Objects.equals(this.lastWeekDay, bankingScheduledPaymentRecurrence.lastWeekDay) && Objects.equals(this.nextPaymentDate, bankingScheduledPaymentRecurrence.nextPaymentDate) && Objects.equals(this.onceOff, bankingScheduledPaymentRecurrence.onceOff) && Objects.equals(this.recurrenceUType, bankingScheduledPaymentRecurrence.recurrenceUType);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.eventBased, this.intervalSchedule, this.lastWeekDay, this.nextPaymentDate, this.onceOff, this.recurrenceUType);
    }

    public String toString() {
        return "class BankingScheduledPaymentRecurrence {\n   id: " + this.toIndentedString((Object)this.id) + "\n   eventBased: " + this.toIndentedString((Object)this.eventBased) + "\n   intervalSchedule: " + this.toIndentedString((Object)this.intervalSchedule) + "\n   lastWeekDay: " + this.toIndentedString((Object)this.lastWeekDay) + "\n   nextPaymentDate: " + this.toIndentedString((Object)this.nextPaymentDate) + "\n   onceOff: " + this.toIndentedString((Object)this.onceOff) + "\n   recurrenceUType: " + this.toIndentedString((Object)this.recurrenceUType) + "\n}";
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

