/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.model;

import au.org.consumerdatastandards.holder.model.BankingScheduledPayment;
import au.org.consumerdatastandards.holder.model.BankingScheduledPaymentFrom;
import au.org.consumerdatastandards.holder.model.BankingScheduledPaymentRecurrence;
import au.org.consumerdatastandards.holder.model.BankingScheduledPaymentSet;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;

@ApiModel
@Entity
public class BankingScheduledPayment {
    @Id
    private String scheduledPaymentId;
    @Embedded
    private BankingScheduledPaymentFrom from;
    private String nickname;
    private String payeeReference;
    private String payerReference;
    @OneToMany
    @JoinTable(name="banking_scheduled_payment_sets", joinColumns={@JoinColumn(name="scheduled_payment_id")}, inverseJoinColumns={@JoinColumn(name="payment_set_id")})
    private List<BankingScheduledPaymentSet> paymentSet;
    @ManyToOne
    private BankingScheduledPaymentRecurrence recurrence;
    private Status status;

    public BankingScheduledPayment from(BankingScheduledPaymentFrom from) {
        this.from = from;
        return this;
    }

    @ApiModelProperty(required=true)
    public BankingScheduledPaymentFrom getFrom() {
        return this.from;
    }

    public void setFrom(BankingScheduledPaymentFrom from) {
        this.from = from;
    }

    public BankingScheduledPayment nickname(String nickname) {
        this.nickname = nickname;
        return this;
    }

    @ApiModelProperty(value="The short display name of the payee as provided by the customer")
    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public BankingScheduledPayment payeeReference(String payeeReference) {
        this.payeeReference = payeeReference;
        return this;
    }

    @ApiModelProperty(required=true, value="The reference for the transaction that will be provided by the originating institution. Empty string if no data provided")
    public String getPayeeReference() {
        return this.payeeReference;
    }

    public void setPayeeReference(String payeeReference) {
        this.payeeReference = payeeReference;
    }

    public BankingScheduledPayment payerReference(String payerReference) {
        this.payerReference = payerReference;
        return this;
    }

    @ApiModelProperty(required=true, value="The reference for the transaction that will be used by the originating institution for the purposes of constructing a statement narrative on the payer\u2019s account. Empty string if no data provided")
    public String getPayerReference() {
        return this.payerReference;
    }

    public void setPayerReference(String payerReference) {
        this.payerReference = payerReference;
    }

    public BankingScheduledPayment paymentSet(List<BankingScheduledPaymentSet> paymentSet) {
        this.paymentSet = paymentSet;
        return this;
    }

    public BankingScheduledPayment addItem(BankingScheduledPaymentSet paymentSetItem) {
        this.paymentSet.add(paymentSetItem);
        return this;
    }

    @ApiModelProperty(required=true)
    public List<BankingScheduledPaymentSet> getPaymentSet() {
        return this.paymentSet;
    }

    public void setPaymentSet(List<BankingScheduledPaymentSet> paymentSet) {
        this.paymentSet = paymentSet;
    }

    public BankingScheduledPayment recurrence(BankingScheduledPaymentRecurrence recurrence) {
        this.recurrence = recurrence;
        return this;
    }

    @ApiModelProperty(required=true)
    public BankingScheduledPaymentRecurrence getRecurrence() {
        return this.recurrence;
    }

    public void setRecurrence(BankingScheduledPaymentRecurrence recurrence) {
        this.recurrence = recurrence;
    }

    public BankingScheduledPayment scheduledPaymentId(String scheduledPaymentId) {
        this.scheduledPaymentId = scheduledPaymentId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique ID of the scheduled payment adhering to the standards for ID permanence")
    public String getScheduledPaymentId() {
        return this.scheduledPaymentId;
    }

    public void setScheduledPaymentId(String scheduledPaymentId) {
        this.scheduledPaymentId = scheduledPaymentId;
    }

    public BankingScheduledPayment status(Status status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true)
    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankingScheduledPayment bankingScheduledPayment = (BankingScheduledPayment)o;
        return Objects.equals(this.from, bankingScheduledPayment.from) && Objects.equals(this.nickname, bankingScheduledPayment.nickname) && Objects.equals(this.payeeReference, bankingScheduledPayment.payeeReference) && Objects.equals(this.payerReference, bankingScheduledPayment.payerReference) && Objects.equals(this.paymentSet, bankingScheduledPayment.paymentSet) && Objects.equals(this.recurrence, bankingScheduledPayment.recurrence) && Objects.equals(this.scheduledPaymentId, bankingScheduledPayment.scheduledPaymentId) && Objects.equals(this.status, bankingScheduledPayment.status);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.nickname, this.payeeReference, this.payerReference, this.paymentSet, this.recurrence, this.scheduledPaymentId, this.status);
    }

    public String toString() {
        return "class BankingScheduledPayment {\n   from: " + this.toIndentedString((Object)this.from) + "\n   nickname: " + this.toIndentedString((Object)this.nickname) + "\n   payeeReference: " + this.toIndentedString((Object)this.payeeReference) + "\n   payerReference: " + this.toIndentedString((Object)this.payerReference) + "\n   paymentSet: " + this.toIndentedString((Object)this.paymentSet) + "\n   recurrence: " + this.toIndentedString((Object)this.recurrence) + "\n   scheduledPaymentId: " + this.toIndentedString((Object)this.scheduledPaymentId) + "\n   status: " + this.toIndentedString((Object)this.status) + "\n}";
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

