/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.model;

import au.org.consumerdatastandards.holder.model.BankingProduct;
import au.org.consumerdatastandards.holder.model.BankingProductAdditionalInformation;
import au.org.consumerdatastandards.holder.model.BankingProductCategory;
import au.org.consumerdatastandards.holder.model.BankingProductV2CardArt;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.springframework.format.annotation.DateTimeFormat;

@Entity
@Table(name="BankingProduct")
public class BankingProductV2
implements BankingProduct {
    @Id
    private String productId;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private OffsetDateTime effectiveFrom;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private OffsetDateTime effectiveTo;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private OffsetDateTime lastUpdated;
    private BankingProductCategory productCategory;
    private String name;
    @Column(length=2048)
    private String description;
    private String brand;
    private String brandName;
    private String applicationUri;
    private Boolean isTailored;
    @OneToOne(cascade={CascadeType.ALL})
    private BankingProductAdditionalInformation additionalInformation;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="product_cardarts", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="cardart_id")})
    private List<BankingProductV2CardArt> cardArt;

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public OffsetDateTime getEffectiveFrom() {
        return this.effectiveFrom;
    }

    public void setEffectiveFrom(OffsetDateTime effectiveFrom) {
        this.effectiveFrom = effectiveFrom;
    }

    public OffsetDateTime getEffectiveTo() {
        return this.effectiveTo;
    }

    public void setEffectiveTo(OffsetDateTime effectiveTo) {
        this.effectiveTo = effectiveTo;
    }

    public OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(OffsetDateTime lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public BankingProductCategory getProductCategory() {
        return this.productCategory;
    }

    public void setProductCategory(BankingProductCategory productCategory) {
        this.productCategory = productCategory;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getBrand() {
        return this.brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getBrandName() {
        return this.brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public String getApplicationUri() {
        return this.applicationUri;
    }

    public void setApplicationUri(String applicationUri) {
        this.applicationUri = applicationUri;
    }

    public Boolean getIsTailored() {
        return this.isTailored;
    }

    public void setIsTailored(Boolean isTailored) {
        this.isTailored = isTailored;
    }

    public BankingProductAdditionalInformation getAdditionalInformation() {
        return this.additionalInformation;
    }

    public void setAdditionalInformation(BankingProductAdditionalInformation additionalInformation) {
        this.additionalInformation = additionalInformation;
    }

    public List<BankingProductV2CardArt> getCardArt() {
        return this.cardArt;
    }

    public void setCardArt(List<BankingProductV2CardArt> cardArt) {
        this.cardArt = cardArt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankingProductV2 that = (BankingProductV2)o;
        return this.productId.equals(that.productId);
    }

    public int hashCode() {
        return Objects.hash(this.productId);
    }

    public String toString() {
        return "BankingProduct{productId='" + this.productId + '\'' + ", effectiveFrom=" + this.effectiveFrom + ", effectiveTo=" + this.effectiveTo + ", lastUpdated=" + this.lastUpdated + ", productCategory=" + this.productCategory + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", brand='" + this.brand + '\'' + ", brandName='" + this.brandName + '\'' + ", applicationUri='" + this.applicationUri + '\'' + ", isTailored=" + this.isTailored + ", additionalInformation=" + this.additionalInformation + ", cardArt=" + this.cardArt + '}';
    }
}

