/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.model;

import au.org.consumerdatastandards.holder.model.BankingProductDiscount;
import au.org.consumerdatastandards.holder.model.BankingProductDiscountEligibility;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.validation.Valid;
import org.hibernate.annotations.GenericGenerator;

@Entity
public class BankingProductDiscount {
    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid2")
    @JsonIgnore
    private String discountId;
    @Column(length=2048)
    private String description;
    private DiscountType discountType;
    private BigDecimal amount;
    private BigDecimal balanceRate;
    private BigDecimal transactionRate;
    private BigDecimal accruedRate;
    private BigDecimal feeRate;
    @Column(length=2048)
    private String additionalValue;
    @Column(length=2048)
    private String additionalInfo;
    private URI additionalInfoUri;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="product_discount_eligibility", joinColumns={@JoinColumn(name="product_discount_id")}, inverseJoinColumns={@JoinColumn(name="discount_eligibility_id")})
    @Valid
    private List<BankingProductDiscountEligibility> eligibility;

    public String getDiscountId() {
        return this.discountId;
    }

    public void setDiscountId(String discountId) {
        this.discountId = discountId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public DiscountType getDiscountType() {
        return this.discountType;
    }

    public void setDiscountType(DiscountType discountType) {
        this.discountType = discountType;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public BigDecimal getBalanceRate() {
        return this.balanceRate;
    }

    public void setBalanceRate(BigDecimal balanceRate) {
        this.balanceRate = balanceRate;
    }

    public BigDecimal getTransactionRate() {
        return this.transactionRate;
    }

    public void setTransactionRate(BigDecimal transactionRate) {
        this.transactionRate = transactionRate;
    }

    public BigDecimal getAccruedRate() {
        return this.accruedRate;
    }

    public void setAccruedRate(BigDecimal accruedRate) {
        this.accruedRate = accruedRate;
    }

    public BigDecimal getFeeRate() {
        return this.feeRate;
    }

    public void setFeeRate(BigDecimal feeRate) {
        this.feeRate = feeRate;
    }

    public String getAdditionalValue() {
        return this.additionalValue;
    }

    public void setAdditionalValue(String additionalValue) {
        this.additionalValue = additionalValue;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public URI getAdditionalInfoUri() {
        return this.additionalInfoUri;
    }

    public void setAdditionalInfoUri(URI additionalInfoUri) {
        this.additionalInfoUri = additionalInfoUri;
    }

    public List<BankingProductDiscountEligibility> getEligibility() {
        return this.eligibility;
    }

    public void setEligibility(List<BankingProductDiscountEligibility> eligibility) {
        this.eligibility = eligibility;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankingProductDiscount that = (BankingProductDiscount)o;
        return Objects.equals(this.discountId, that.discountId);
    }

    public int hashCode() {
        return Objects.hash(this.discountId);
    }

    public String toString() {
        return "BankingProductDiscount{discountId='" + this.discountId + '\'' + ", description='" + this.description + '\'' + ", discountType=" + this.discountType + ", amount=" + this.amount + ", balanceRate=" + this.balanceRate + ", transactionRate=" + this.transactionRate + ", accruedRate=" + this.accruedRate + ", feeRate=" + this.feeRate + ", additionalValue='" + this.additionalValue + '\'' + ", additionalInfo='" + this.additionalInfo + '\'' + ", additionalInfoUri=" + this.additionalInfoUri + ", eligibility=" + this.eligibility + '}';
    }
}

