/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.model;

import au.org.consumerdatastandards.holder.model.BankingBillerPayee;
import au.org.consumerdatastandards.holder.model.BankingDomesticPayee;
import au.org.consumerdatastandards.holder.model.BankingInternationalPayee;
import au.org.consumerdatastandards.holder.model.BankingPayee;
import au.org.consumerdatastandards.holder.model.BankingPayeeDetail;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.springframework.format.annotation.DateTimeFormat;

@ApiModel
@Entity
@Table(name="BankingPayee")
public class BankingPayeeDetail {
    @Id
    private String payeeId;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private LocalDate creationDate;
    private String description;
    private String nickname;
    private BankingPayee.Type type;
    @ManyToOne
    private BankingBillerPayee biller;
    @ManyToOne
    private BankingDomesticPayee domestic;
    @ManyToOne
    private BankingInternationalPayee international;
    private PayeeUType payeeUType;

    public String getPayeeId() {
        return this.payeeId;
    }

    public void setPayeeId(String payeeId) {
        this.payeeId = payeeId;
    }

    public LocalDate getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(LocalDate creationDate) {
        this.creationDate = creationDate;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public BankingPayee.Type getType() {
        return this.type;
    }

    public void setType(BankingPayee.Type type) {
        this.type = type;
    }

    public BankingPayeeDetail creationDate(LocalDate creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    public BankingPayeeDetail description(String description) {
        this.description = description;
        return this;
    }

    public BankingPayeeDetail nickname(String nickname) {
        this.nickname = nickname;
        return this;
    }

    public BankingPayeeDetail payeeId(String payeeId) {
        this.payeeId = payeeId;
        return this;
    }

    public BankingPayeeDetail type(BankingPayee.Type type) {
        this.type = type;
        return this;
    }

    public BankingPayeeDetail biller(BankingBillerPayee biller) {
        this.biller = biller;
        return this;
    }

    @ApiModelProperty
    public BankingBillerPayee getBiller() {
        return this.biller;
    }

    public void setBiller(BankingBillerPayee biller) {
        this.biller = biller;
    }

    public BankingPayeeDetail domestic(BankingDomesticPayee domestic) {
        this.domestic = domestic;
        return this;
    }

    @ApiModelProperty
    public BankingDomesticPayee getDomestic() {
        return this.domestic;
    }

    public void setDomestic(BankingDomesticPayee domestic) {
        this.domestic = domestic;
    }

    public BankingPayeeDetail international(BankingInternationalPayee international) {
        this.international = international;
        return this;
    }

    @ApiModelProperty
    public BankingInternationalPayee getInternational() {
        return this.international;
    }

    public void setInternational(BankingInternationalPayee international) {
        this.international = international;
    }

    public BankingPayeeDetail payeeUType(PayeeUType payeeUType) {
        this.payeeUType = payeeUType;
        return this;
    }

    @ApiModelProperty(required=true)
    public PayeeUType getPayeeUType() {
        return this.payeeUType;
    }

    public void setPayeeUType(PayeeUType payeeUType) {
        this.payeeUType = payeeUType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankingPayeeDetail bankingPayeeDetail = (BankingPayeeDetail)o;
        return Objects.equals(this.biller, bankingPayeeDetail.biller) && Objects.equals(this.domestic, bankingPayeeDetail.domestic) && Objects.equals(this.international, bankingPayeeDetail.international) && Objects.equals(this.payeeUType, bankingPayeeDetail.payeeUType) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(this.biller, this.domestic, this.international, this.payeeUType, super.hashCode());
    }

    public String toString() {
        return "class BankingPayeeDetail {\n   creationDate: " + this.toIndentedString((Object)this.getCreationDate()) + "\n   description: " + this.toIndentedString((Object)this.getDescription()) + "\n   nickname: " + this.toIndentedString((Object)this.getNickname()) + "\n   payeeId: " + this.toIndentedString((Object)this.getPayeeId()) + "\n   type: " + this.toIndentedString((Object)this.getType()) + "\n   biller: " + this.toIndentedString((Object)this.biller) + "\n   domestic: " + this.toIndentedString((Object)this.domestic) + "\n   international: " + this.toIndentedString((Object)this.international) + "\n   payeeUType: " + this.toIndentedString((Object)this.payeeUType) + "\n}";
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

