/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.model;

import au.org.consumerdatastandards.holder.model.BankingLoanAccount;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.format.annotation.DateTimeFormat;

@ApiModel
@Entity
public class BankingLoanAccount {
    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid2")
    @JsonIgnore
    private String id;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private LocalDate loanEndDate;
    private String maxRedraw;
    private String maxRedrawCurrency;
    private String minInstalmentAmount;
    private String minInstalmentCurrency;
    private String minRedraw;
    private String minRedrawCurrency;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private LocalDate nextInstalmentDate;
    private Boolean offsetAccountEnabled;
    @ElementCollection
    private List<String> offsetAccountIds;
    private String originalLoanAmount;
    private String originalLoanCurrency;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private LocalDate originalStartDate;
    private String repaymentFrequency;
    private RepaymentType repaymentType;

    public BankingLoanAccount loanEndDate(LocalDate loanEndDate) {
        this.loanEndDate = loanEndDate;
        return this;
    }

    @ApiModelProperty(required=true, value="Date that the loan is due to be repaid in full")
    public LocalDate getLoanEndDate() {
        return this.loanEndDate;
    }

    public void setLoanEndDate(LocalDate loanEndDate) {
        this.loanEndDate = loanEndDate;
    }

    public BankingLoanAccount maxRedraw(String maxRedraw) {
        this.maxRedraw = maxRedraw;
        return this;
    }

    @ApiModelProperty(value="Maximum amount of funds that can be redrawn. If not present redraw is not available even if the feature exists for the account")
    public String getMaxRedraw() {
        return this.maxRedraw;
    }

    public void setMaxRedraw(String maxRedraw) {
        this.maxRedraw = maxRedraw;
    }

    public BankingLoanAccount maxRedrawCurrency(String maxRedrawCurrency) {
        this.maxRedrawCurrency = maxRedrawCurrency;
        return this;
    }

    @ApiModelProperty(value="If absent assumes AUD")
    public String getMaxRedrawCurrency() {
        return this.maxRedrawCurrency;
    }

    public void setMaxRedrawCurrency(String maxRedrawCurrency) {
        this.maxRedrawCurrency = maxRedrawCurrency;
    }

    public BankingLoanAccount minInstalmentAmount(String minInstalmentAmount) {
        this.minInstalmentAmount = minInstalmentAmount;
        return this;
    }

    @ApiModelProperty(value="Minimum amount of next instalment")
    public String getMinInstalmentAmount() {
        return this.minInstalmentAmount;
    }

    public void setMinInstalmentAmount(String minInstalmentAmount) {
        this.minInstalmentAmount = minInstalmentAmount;
    }

    public BankingLoanAccount minInstalmentCurrency(String minInstalmentCurrency) {
        this.minInstalmentCurrency = minInstalmentCurrency;
        return this;
    }

    @ApiModelProperty(value="If absent assumes AUD")
    public String getMinInstalmentCurrency() {
        return this.minInstalmentCurrency;
    }

    public void setMinInstalmentCurrency(String minInstalmentCurrency) {
        this.minInstalmentCurrency = minInstalmentCurrency;
    }

    public BankingLoanAccount minRedraw(String minRedraw) {
        this.minRedraw = minRedraw;
        return this;
    }

    @ApiModelProperty(value="Minimum redraw amount")
    public String getMinRedraw() {
        return this.minRedraw;
    }

    public void setMinRedraw(String minRedraw) {
        this.minRedraw = minRedraw;
    }

    public BankingLoanAccount minRedrawCurrency(String minRedrawCurrency) {
        this.minRedrawCurrency = minRedrawCurrency;
        return this;
    }

    @ApiModelProperty(value="If absent assumes AUD")
    public String getMinRedrawCurrency() {
        return this.minRedrawCurrency;
    }

    public void setMinRedrawCurrency(String minRedrawCurrency) {
        this.minRedrawCurrency = minRedrawCurrency;
    }

    public BankingLoanAccount nextInstalmentDate(LocalDate nextInstalmentDate) {
        this.nextInstalmentDate = nextInstalmentDate;
        return this;
    }

    @ApiModelProperty(required=true, value="Next date that an instalment is required")
    public LocalDate getNextInstalmentDate() {
        return this.nextInstalmentDate;
    }

    public void setNextInstalmentDate(LocalDate nextInstalmentDate) {
        this.nextInstalmentDate = nextInstalmentDate;
    }

    public BankingLoanAccount offsetAccountEnabled(Boolean offsetAccountEnabled) {
        this.offsetAccountEnabled = offsetAccountEnabled;
        return this;
    }

    @ApiModelProperty(value="Set to true if one or more offset accounts are configured for this loan account")
    public Boolean getOffsetAccountEnabled() {
        return this.offsetAccountEnabled;
    }

    public void setOffsetAccountEnabled(Boolean offsetAccountEnabled) {
        this.offsetAccountEnabled = offsetAccountEnabled;
    }

    public BankingLoanAccount offsetAccountIds(List<String> offsetAccountIds) {
        this.offsetAccountIds = offsetAccountIds;
        return this;
    }

    public BankingLoanAccount addItem(String offsetAccountIdsItem) {
        if (this.offsetAccountIds == null) {
            this.offsetAccountIds = new ArrayList();
        }
        this.offsetAccountIds.add(offsetAccountIdsItem);
        return this;
    }

    @ApiModelProperty(value="The accountIDs of the configured offset accounts attached to this loan. Only offset accounts that can be accessed under the current authorisation should be included. It is expected behaviour that offsetAccountEnabled is set to true but the offsetAccountIds field is absent or empty. This represents a situation where an offset account exists but details can not be accessed under the current authorisation")
    public List<String> getOffsetAccountIds() {
        return this.offsetAccountIds;
    }

    public void setOffsetAccountIds(List<String> offsetAccountIds) {
        this.offsetAccountIds = offsetAccountIds;
    }

    public BankingLoanAccount originalLoanAmount(String originalLoanAmount) {
        this.originalLoanAmount = originalLoanAmount;
        return this;
    }

    @ApiModelProperty(value="Optional original loan value")
    public String getOriginalLoanAmount() {
        return this.originalLoanAmount;
    }

    public void setOriginalLoanAmount(String originalLoanAmount) {
        this.originalLoanAmount = originalLoanAmount;
    }

    public BankingLoanAccount originalLoanCurrency(String originalLoanCurrency) {
        this.originalLoanCurrency = originalLoanCurrency;
        return this;
    }

    @ApiModelProperty(value="If absent assumes AUD")
    public String getOriginalLoanCurrency() {
        return this.originalLoanCurrency;
    }

    public void setOriginalLoanCurrency(String originalLoanCurrency) {
        this.originalLoanCurrency = originalLoanCurrency;
    }

    public BankingLoanAccount originalStartDate(LocalDate originalStartDate) {
        this.originalStartDate = originalStartDate;
        return this;
    }

    @ApiModelProperty(value="Optional original start date for the loan")
    public LocalDate getOriginalStartDate() {
        return this.originalStartDate;
    }

    public void setOriginalStartDate(LocalDate originalStartDate) {
        this.originalStartDate = originalStartDate;
    }

    public BankingLoanAccount repaymentFrequency(String repaymentFrequency) {
        this.repaymentFrequency = repaymentFrequency;
        return this;
    }

    @ApiModelProperty(required=true, value="The expected or required repayment frequency. Formatted according to [ISO 8601 Durations](https://en.wikipedia.org/wiki/ISO_8601#Durations)")
    public String getRepaymentFrequency() {
        return this.repaymentFrequency;
    }

    public void setRepaymentFrequency(String repaymentFrequency) {
        this.repaymentFrequency = repaymentFrequency;
    }

    public BankingLoanAccount repaymentType(RepaymentType repaymentType) {
        this.repaymentType = repaymentType;
        return this;
    }

    @ApiModelProperty
    public RepaymentType getRepaymentType() {
        return this.repaymentType;
    }

    public void setRepaymentType(RepaymentType repaymentType) {
        this.repaymentType = repaymentType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankingLoanAccount bankingLoanAccount = (BankingLoanAccount)o;
        return Objects.equals(this.id, bankingLoanAccount.id) && Objects.equals(this.loanEndDate, bankingLoanAccount.loanEndDate) && Objects.equals(this.maxRedraw, bankingLoanAccount.maxRedraw) && Objects.equals(this.maxRedrawCurrency, bankingLoanAccount.maxRedrawCurrency) && Objects.equals(this.minInstalmentAmount, bankingLoanAccount.minInstalmentAmount) && Objects.equals(this.minInstalmentCurrency, bankingLoanAccount.minInstalmentCurrency) && Objects.equals(this.minRedraw, bankingLoanAccount.minRedraw) && Objects.equals(this.minRedrawCurrency, bankingLoanAccount.minRedrawCurrency) && Objects.equals(this.nextInstalmentDate, bankingLoanAccount.nextInstalmentDate) && Objects.equals(this.offsetAccountEnabled, bankingLoanAccount.offsetAccountEnabled) && Objects.equals(this.offsetAccountIds, bankingLoanAccount.offsetAccountIds) && Objects.equals(this.originalLoanAmount, bankingLoanAccount.originalLoanAmount) && Objects.equals(this.originalLoanCurrency, bankingLoanAccount.originalLoanCurrency) && Objects.equals(this.originalStartDate, bankingLoanAccount.originalStartDate) && Objects.equals(this.repaymentFrequency, bankingLoanAccount.repaymentFrequency) && Objects.equals(this.repaymentType, bankingLoanAccount.repaymentType);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.loanEndDate, this.maxRedraw, this.maxRedrawCurrency, this.minInstalmentAmount, this.minInstalmentCurrency, this.minRedraw, this.minRedrawCurrency, this.nextInstalmentDate, this.offsetAccountEnabled, this.offsetAccountIds, this.originalLoanAmount, this.originalLoanCurrency, this.originalStartDate, this.repaymentFrequency, this.repaymentType);
    }

    public String toString() {
        return "class BankingLoanAccount {\n   id: " + this.toIndentedString((Object)this.id) + "\n   loanEndDate: " + this.toIndentedString((Object)this.loanEndDate) + "\n   maxRedraw: " + this.toIndentedString((Object)this.maxRedraw) + "\n   maxRedrawCurrency: " + this.toIndentedString((Object)this.maxRedrawCurrency) + "\n   minInstalmentAmount: " + this.toIndentedString((Object)this.minInstalmentAmount) + "\n   minInstalmentCurrency: " + this.toIndentedString((Object)this.minInstalmentCurrency) + "\n   minRedraw: " + this.toIndentedString((Object)this.minRedraw) + "\n   minRedrawCurrency: " + this.toIndentedString((Object)this.minRedrawCurrency) + "\n   nextInstalmentDate: " + this.toIndentedString((Object)this.nextInstalmentDate) + "\n   offsetAccountEnabled: " + this.toIndentedString((Object)this.offsetAccountEnabled) + "\n   offsetAccountIds: " + this.toIndentedString((Object)this.offsetAccountIds) + "\n   originalLoanAmount: " + this.toIndentedString((Object)this.originalLoanAmount) + "\n   originalLoanCurrency: " + this.toIndentedString((Object)this.originalLoanCurrency) + "\n   originalStartDate: " + this.toIndentedString((Object)this.originalStartDate) + "\n   repaymentFrequency: " + this.toIndentedString((Object)this.repaymentFrequency) + "\n   repaymentType: " + this.toIndentedString((Object)this.repaymentType) + "\n}";
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

