/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.model;

import au.org.consumerdatastandards.holder.model.BankingAccount;
import au.org.consumerdatastandards.holder.model.BankingAuthorisedEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.format.annotation.DateTimeFormat;

@ApiModel
@Entity
public class BankingDirectDebit {
    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid2")
    @JsonIgnore
    private String id;
    private String accountId;
    @JsonIgnore
    @ManyToOne
    @JoinColumn(updatable=false)
    private BankingAccount bankingAccount;
    @ManyToOne
    private BankingAuthorisedEntity authorisedEntity;
    private String lastDebitAmount;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private OffsetDateTime lastDebitDateTime;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BankingDirectDebit accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique ID of the account adhering to the standards for ID permanence.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public BankingDirectDebit authorisedEntity(BankingAuthorisedEntity authorisedEntity) {
        this.authorisedEntity = authorisedEntity;
        return this;
    }

    public BankingAccount getBankingAccount() {
        return this.bankingAccount;
    }

    public void setBankingAccount(BankingAccount bankingAccount) {
        this.bankingAccount = bankingAccount;
    }

    @ApiModelProperty(required=true)
    public BankingAuthorisedEntity getAuthorisedEntity() {
        return this.authorisedEntity;
    }

    public void setAuthorisedEntity(BankingAuthorisedEntity authorisedEntity) {
        this.authorisedEntity = authorisedEntity;
    }

    public BankingDirectDebit lastDebitAmount(String lastDebitAmount) {
        this.lastDebitAmount = lastDebitAmount;
        return this;
    }

    @ApiModelProperty(value="The amount of the last debit executed under this authorisation")
    public String getLastDebitAmount() {
        return this.lastDebitAmount;
    }

    public void setLastDebitAmount(String lastDebitAmount) {
        this.lastDebitAmount = lastDebitAmount;
    }

    public BankingDirectDebit lastDebitDateTime(OffsetDateTime lastDebitDateTime) {
        this.lastDebitDateTime = lastDebitDateTime;
        return this;
    }

    @ApiModelProperty(value="The date and time of the last debit executed under this authorisation")
    public OffsetDateTime getLastDebitDateTime() {
        return this.lastDebitDateTime;
    }

    public void setLastDebitDateTime(OffsetDateTime lastDebitDateTime) {
        this.lastDebitDateTime = lastDebitDateTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankingDirectDebit bankingDirectDebit = (BankingDirectDebit)o;
        return Objects.equals(this.id, bankingDirectDebit.id) && Objects.equals(this.accountId, bankingDirectDebit.accountId) && Objects.equals(this.authorisedEntity, bankingDirectDebit.authorisedEntity) && Objects.equals(this.lastDebitAmount, bankingDirectDebit.lastDebitAmount) && Objects.equals(this.lastDebitDateTime, bankingDirectDebit.lastDebitDateTime);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.accountId, this.authorisedEntity, this.lastDebitAmount, this.lastDebitDateTime);
    }

    public String toString() {
        return "class BankingDirectDebit {\n   id: " + this.toIndentedString((Object)this.id) + "\n   accountId: " + this.toIndentedString((Object)this.accountId) + "\n   authorisedEntity: " + this.toIndentedString((Object)this.authorisedEntity) + "\n   lastDebitAmount: " + this.toIndentedString((Object)this.lastDebitAmount) + "\n   lastDebitDateTime: " + this.toIndentedString((Object)this.lastDebitDateTime) + "\n}";
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

