/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.hibernate.annotations.GenericGenerator;

@ApiModel
@Entity
public class BankingAuthorisedEntity {
    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid2")
    @JsonIgnore
    private String id;
    private String abn;
    private String acn;
    private String arbn;
    private String description;
    private String financialInstitution;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BankingAuthorisedEntity abn(String abn) {
        this.abn = abn;
        return this;
    }

    @ApiModelProperty(value="Australian Business Number for the authorised entity")
    public String getAbn() {
        return this.abn;
    }

    public void setAbn(String abn) {
        this.abn = abn;
    }

    public BankingAuthorisedEntity acn(String acn) {
        this.acn = acn;
        return this;
    }

    @ApiModelProperty(value="Australian Company Number for the authorised entity")
    public String getAcn() {
        return this.acn;
    }

    public void setAcn(String acn) {
        this.acn = acn;
    }

    public BankingAuthorisedEntity arbn(String arbn) {
        this.arbn = arbn;
        return this;
    }

    @ApiModelProperty(value="Australian Registered Body Number for the authorised entity")
    public String getArbn() {
        return this.arbn;
    }

    public void setArbn(String arbn) {
        this.arbn = arbn;
    }

    public BankingAuthorisedEntity description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description of the authorised entity derived from previously executed direct debits")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BankingAuthorisedEntity financialInstitution(String financialInstitution) {
        this.financialInstitution = financialInstitution;
        return this;
    }

    @ApiModelProperty(value="Name of the financial institution through which the direct debit will be executed. Is required unless the payment is made via a credit card scheme")
    public String getFinancialInstitution() {
        return this.financialInstitution;
    }

    public void setFinancialInstitution(String financialInstitution) {
        this.financialInstitution = financialInstitution;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankingAuthorisedEntity bankingAuthorisedEntity = (BankingAuthorisedEntity)o;
        return Objects.equals(this.id, bankingAuthorisedEntity.id) && Objects.equals(this.abn, bankingAuthorisedEntity.abn) && Objects.equals(this.acn, bankingAuthorisedEntity.acn) && Objects.equals(this.arbn, bankingAuthorisedEntity.arbn) && Objects.equals(this.description, bankingAuthorisedEntity.description) && Objects.equals(this.financialInstitution, bankingAuthorisedEntity.financialInstitution);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.abn, this.acn, this.arbn, this.description, this.financialInstitution);
    }

    public String toString() {
        return "class BankingAuthorisedEntity {\n   id: " + this.toIndentedString((Object)this.id) + "\n   abn: " + this.toIndentedString((Object)this.abn) + "\n   acn: " + this.toIndentedString((Object)this.acn) + "\n   arbn: " + this.toIndentedString((Object)this.arbn) + "\n   description: " + this.toIndentedString((Object)this.description) + "\n   financialInstitution: " + this.toIndentedString((Object)this.financialInstitution) + "\n}";
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

