/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.api;

import au.org.consumerdatastandards.holder.api.ApiControllerBase;
import au.org.consumerdatastandards.holder.api.CommonDiscoveryApi;
import au.org.consumerdatastandards.holder.model.Links;
import au.org.consumerdatastandards.holder.model.ResponseCommonDiscoveryStatus;
import au.org.consumerdatastandards.holder.model.ResponseCommonDiscoveryStatusData;
import au.org.consumerdatastandards.holder.model.ResponseDiscoveryOutagesList;
import au.org.consumerdatastandards.holder.model.ResponseDiscoveryOutagesListData;
import au.org.consumerdatastandards.holder.service.DiscoveryOutageService;
import au.org.consumerdatastandards.holder.util.WebUtil;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.request.NativeWebRequest;

@Validated
@Controller
@RequestMapping(value={"${openapi.consumerDataStandards.base-path:/cds-au/v1}"})
public class CommonDiscoveryApiController
extends ApiControllerBase
implements CommonDiscoveryApi {
    private final DiscoveryOutageService outageService;
    private final NativeWebRequest request;

    @Autowired
    public CommonDiscoveryApiController(NativeWebRequest request, DiscoveryOutageService outageService) {
        this.request = request;
        this.outageService = outageService;
    }

    public Optional<NativeWebRequest> getRequest() {
        return Optional.ofNullable(this.request);
    }

    public ResponseEntity<ResponseDiscoveryOutagesList> getOutages(Integer xMinV, Integer xV) {
        this.validateHeaders(xMinV, xV);
        ResponseDiscoveryOutagesListData listData = new ResponseDiscoveryOutagesListData();
        ArrayList outages = new ArrayList();
        Iterable outageIter = this.outageService.getOutages();
        outageIter.forEach(outages::add);
        listData.setOutages(outages);
        ResponseDiscoveryOutagesList responseDiscoveryOutagesList = new ResponseDiscoveryOutagesList();
        responseDiscoveryOutagesList.setData(listData);
        responseDiscoveryOutagesList.setLinks(new Links().self(WebUtil.getOriginalUrl((NativeWebRequest)this.request)));
        return new ResponseEntity((Object)responseDiscoveryOutagesList, (MultiValueMap)this.generateResponseHeaders(this.request), HttpStatus.OK);
    }

    public ResponseEntity<ResponseCommonDiscoveryStatus> getStatus(Integer xMinV, Integer xV) {
        this.validateHeaders(xMinV, xV);
        ResponseCommonDiscoveryStatusData data = new ResponseCommonDiscoveryStatusData();
        data.setStatus(ResponseCommonDiscoveryStatusData.Status.OK);
        ResponseCommonDiscoveryStatus responseCommonDiscoveryStatus = new ResponseCommonDiscoveryStatus();
        responseCommonDiscoveryStatus.setData(data);
        responseCommonDiscoveryStatus.setLinks(new Links().self(WebUtil.getOriginalUrl((NativeWebRequest)this.request)));
        return new ResponseEntity((Object)responseCommonDiscoveryStatus, (MultiValueMap)this.generateResponseHeaders(this.request), HttpStatus.OK);
    }
}

