/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.api;

import au.org.consumerdatastandards.holder.model.ResponseCommonCustomer;
import au.org.consumerdatastandards.holder.model.ResponseCommonCustomerDetail;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.request.NativeWebRequest;

@Api(value="CommonCustomer", description="the CommonCustomer API")
public interface CommonCustomerApi {
    default public Optional<NativeWebRequest> getRequest() {
        return Optional.empty();
    }

    @ApiOperation(value="Get Customer", nickname="getCustomer", notes="Obtain basic information on the customer that has authorised the current session", response=ResponseCommonCustomer.class, tags={"Customer", "Common"})
    @ApiResponses(value={@ApiResponse(code=200, message="Success", response=ResponseCommonCustomer.class)})
    @RequestMapping(value={"/common/customer"}, method={RequestMethod.GET})
    @PreAuthorize(value="hasAuthority('SCOPE_common:customer.basic:read')")
    public ResponseEntity<ResponseCommonCustomer> getCustomer(@AuthenticationPrincipal Jwt var1, @ApiParam(value="The customers original User Agent header if the customer is currently logged in to the data recipient. Mandatory for customer present calls. Not required for unattended or unauthenticated calls. Base64 encoded contents which may included additional parameters.") @RequestHeader(value="x-cds-client-headers", required=false) String var2, @ApiParam(value="The customer's original standard http headers [Base64](#common-field-types) encoded, including the original User Agent header, if the customer is currently logged in to the data recipient. Mandatory for customer present calls.  Not required for unattended or unauthenticated calls.") @RequestHeader(value="x-fapi-auth-date", required=false) @NotNull @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime var3, @ApiParam(value="The customer's original IP address if the customer is currently logged in to the data recipient. The presence of this header indicates that the API is being called in a customer present context. Not to be included for unauthenticated calls.") @RequestHeader(value="x-fapi-customer-ip-address", required=false) String var4, @ApiParam(value="An [RFC4122](https://tools.ietf.org/html/rfc4122) UID used as a correlation id. If provided, the data holder must play back this value in the x-fapi-interaction-id response header. If not provided a [RFC4122] UUID value is required to be provided in the response header to track the interaction.") @RequestHeader(value="x-fapi-interaction-id", required=false) UUID var5, @ApiParam(value="Minimum version of the API end point requested by the client. Must be set to a positive integer if provided. The data holder should respond with the highest supported version between [x-min-v](#request-headers) and [x-v](#request-headers). If all versions requested are not supported then the data holder should respond with a 406 Not Acceptable.") @RequestHeader(value="x-min-v", required=false) @Min(value=1L) @Min(value=1L) Integer var6, @ApiParam(value="Version of the API end point requested by the client. Must be set to a positive integer. The data holder should respond with the highest supported version between [x-min-v](#request-headers) and [x-v](#request-headers). If the value of [x-min-v](#request-headers) is equal to or higher than the value of [x-v](#request-headers) then the [x-min-v](#request-headers) header should be treated as absent. If all versions requested are not supported then the data holder should respond with a 406 Not Acceptable. See [HTTP Headers](#request-headers)") @RequestHeader(value="x-v", required=false) @Min(value=1L) @Min(value=1L) Integer var7);

    @ApiOperation(value="Get Customer Detail", nickname="getCustomerDetail", notes="Obtain detailed information on the authorised customer within the current session.", response=ResponseCommonCustomerDetail.class, tags={"Customer", "Common"})
    @ApiResponses(value={@ApiResponse(code=200, message="Success", response=ResponseCommonCustomerDetail.class)})
    @RequestMapping(value={"/common/customer/detail"}, method={RequestMethod.GET})
    @PreAuthorize(value="hasAuthority('SCOPE_common:customer.detail:read')")
    public ResponseEntity<ResponseCommonCustomerDetail> getCustomerDetail(@AuthenticationPrincipal Jwt var1, @ApiParam(value="The customers original User Agent header if the customer is currently logged in to the data recipient. Mandatory for customer present calls. Not required for unattended or unauthenticated calls. Base64 encoded contents which may included additional parameters.") @RequestHeader(value="x-cds-client-headers", required=false) String var2, @ApiParam(value="The customer's original standard http headers [Base64](#common-field-types) encoded, including the original User Agent header, if the customer is currently logged in to the data recipient. Mandatory for customer present calls.  Not required for unattended or unauthenticated calls.") @RequestHeader(value="x-fapi-auth-date", required=false) @NotNull @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime var3, @ApiParam(value="The customer's original IP address if the customer is currently logged in to the data recipient. The presence of this header indicates that the API is being called in a customer present context. Not to be included for unauthenticated calls.") @RequestHeader(value="x-fapi-customer-ip-address", required=false) String var4, @ApiParam(value="An [RFC4122](https://tools.ietf.org/html/rfc4122) UID used as a correlation id. If provided, the data holder must play back this value in the x-fapi-interaction-id response header. If not provided a [RFC4122] UUID value is required to be provided in the response header to track the interaction.") @RequestHeader(value="x-fapi-interaction-id", required=false) UUID var5, @ApiParam(value="Minimum version of the API end point requested by the client. Must be set to a positive integer if provided. The data holder should respond with the highest supported version between [x-min-v](#request-headers) and [x-v](#request-headers). If all versions requested are not supported then the data holder should respond with a 406 Not Acceptable.") @RequestHeader(value="x-min-v", required=false) @Min(value=1L) @Min(value=1L) Integer var6, @ApiParam(value="Version of the API end point requested by the client. Must be set to a positive integer. The data holder should respond with the highest supported version between [x-min-v](#request-headers) and [x-v](#request-headers). If the value of [x-min-v](#request-headers) is equal to or higher than the value of [x-v](#request-headers) then the [x-min-v](#request-headers) header should be treated as absent. If all versions requested are not supported then the data holder should respond with a 406 Not Acceptable. See [HTTP Headers](#request-headers)") @RequestHeader(value="x-v", required=false) @Min(value=1L) @Min(value=1L) Integer var7);
}

