/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.api;

import au.org.consumerdatastandards.holder.api.ApiControllerBase;
import au.org.consumerdatastandards.holder.api.BankingScheduledPaymentsApi;
import au.org.consumerdatastandards.holder.model.BankingProductCategory;
import au.org.consumerdatastandards.holder.model.BankingScheduledPayment;
import au.org.consumerdatastandards.holder.model.ParamAccountOpenStatus;
import au.org.consumerdatastandards.holder.model.ParamProductCategory;
import au.org.consumerdatastandards.holder.model.RequestAccountIds;
import au.org.consumerdatastandards.holder.model.ResponseBankingScheduledPaymentsList;
import au.org.consumerdatastandards.holder.model.ResponseBankingScheduledPaymentsListData;
import au.org.consumerdatastandards.holder.service.BankingScheduledPaymentService;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.request.NativeWebRequest;

@Validated
@Controller
@RequestMapping(value={"${openapi.consumerDataStandards.base-path:/cds-au/v1}"})
public class BankingScheduledPaymentsApiController
extends ApiControllerBase
implements BankingScheduledPaymentsApi {
    private final BankingScheduledPaymentService scheduledPaymentService;
    private final NativeWebRequest request;

    @Autowired
    public BankingScheduledPaymentsApiController(NativeWebRequest request, BankingScheduledPaymentService scheduledPaymentService) {
        this.request = request;
        this.scheduledPaymentService = scheduledPaymentService;
    }

    public Optional<NativeWebRequest> getRequest() {
        return Optional.ofNullable(this.request);
    }

    public ResponseEntity<ResponseBankingScheduledPaymentsList> listScheduledPayments(String accountId, Integer page, Integer pageSize, String xCdsClientHeaders, OffsetDateTime xFapiAuthDate, String xFapiCustomerIpAddress, UUID xFapiInteractionId, Integer xMinV, Integer xV) {
        this.validateHeaders(xCdsClientHeaders, xFapiCustomerIpAddress, xMinV, xV);
        this.validatePageInputs(page, pageSize);
        HttpHeaders headers = this.generateResponseHeaders(this.request);
        Integer actualPage = this.getPagingValue(page, 1);
        Integer actualPageSize = this.getPagingValue(pageSize, 25);
        ResponseBankingScheduledPaymentsListData listData = new ResponseBankingScheduledPaymentsListData();
        Page scheduledPaymentPage = this.scheduledPaymentService.getBankingScheduledPayments(accountId, (Pageable)PageRequest.of((int)(actualPage - 1), (int)actualPageSize));
        return this.getResponse(headers, actualPage, actualPageSize, listData, scheduledPaymentPage);
    }

    public ResponseEntity<ResponseBankingScheduledPaymentsList> listScheduledPaymentsBulk(ParamProductCategory productCategory, ParamAccountOpenStatus openStatus, Boolean isOwned, Integer page, Integer pageSize, String xCdsClientHeaders, OffsetDateTime xFapiAuthDate, String xFapiCustomerIpAddress, UUID xFapiInteractionId, Integer xMinV, Integer xV) {
        this.validateHeaders(xCdsClientHeaders, xFapiCustomerIpAddress, xMinV, xV);
        this.validatePageInputs(page, pageSize);
        HttpHeaders headers = this.generateResponseHeaders(this.request);
        Integer actualPage = this.getPagingValue(page, 1);
        Integer actualPageSize = this.getPagingValue(pageSize, 25);
        ResponseBankingScheduledPaymentsListData listData = new ResponseBankingScheduledPaymentsListData();
        Page scheduledPaymentPage = this.scheduledPaymentService.getBankingScheduledPayments(BankingProductCategory.valueOf((String)productCategory.name()), openStatus, isOwned, (Pageable)PageRequest.of((int)(actualPage - 1), (int)actualPageSize));
        return this.getResponse(headers, actualPage, actualPageSize, listData, scheduledPaymentPage);
    }

    public ResponseEntity<ResponseBankingScheduledPaymentsList> listScheduledPaymentsSpecificAccounts(RequestAccountIds accountIds, Integer page, Integer pageSize, String xCdsClientHeaders, OffsetDateTime xFapiAuthDate, String xFapiCustomerIpAddress, UUID xFapiInteractionId, Integer xMinV, Integer xV) {
        this.validateHeaders(xCdsClientHeaders, xFapiCustomerIpAddress, xMinV, xV);
        this.validatePageInputs(page, pageSize);
        HttpHeaders headers = this.generateResponseHeaders(this.request);
        Integer actualPage = this.getPagingValue(page, 1);
        Integer actualPageSize = this.getPagingValue(pageSize, 25);
        ResponseBankingScheduledPaymentsListData listData = new ResponseBankingScheduledPaymentsListData();
        Page scheduledPaymentPage = this.scheduledPaymentService.getBankingScheduledPayments(accountIds.getData().getAccountIds(), (Pageable)PageRequest.of((int)(actualPage - 1), (int)actualPageSize));
        return this.getResponse(headers, actualPage, actualPageSize, listData, scheduledPaymentPage);
    }

    private ResponseEntity<ResponseBankingScheduledPaymentsList> getResponse(HttpHeaders headers, Integer actualPage, Integer actualPageSize, ResponseBankingScheduledPaymentsListData listData, Page<BankingScheduledPayment> scheduledPaymentPage) {
        listData.setScheduledPayments(scheduledPaymentPage.getContent());
        ResponseBankingScheduledPaymentsList responseBankingScheduledPaymentsList = new ResponseBankingScheduledPaymentsList();
        responseBankingScheduledPaymentsList.setData(listData);
        responseBankingScheduledPaymentsList.setLinks(this.getLinkData(this.request, scheduledPaymentPage, actualPage, actualPageSize));
        responseBankingScheduledPaymentsList.setMeta(this.getMetaData(scheduledPaymentPage));
        return new ResponseEntity((Object)responseBankingScheduledPaymentsList, (MultiValueMap)headers, HttpStatus.OK);
    }
}

