/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.api;

import au.org.consumerdatastandards.holder.api.ApiControllerBase;
import au.org.consumerdatastandards.holder.api.BankingPayeesApi;
import au.org.consumerdatastandards.holder.model.BankingPayee;
import au.org.consumerdatastandards.holder.model.BankingPayeeDetail;
import au.org.consumerdatastandards.holder.model.Links;
import au.org.consumerdatastandards.holder.model.ResponseBankingPayeeById;
import au.org.consumerdatastandards.holder.model.ResponseBankingPayeeList;
import au.org.consumerdatastandards.holder.model.ResponseBankingPayeeListData;
import au.org.consumerdatastandards.holder.service.BankingPayeeService;
import au.org.consumerdatastandards.holder.util.WebUtil;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.request.NativeWebRequest;

@Validated
@Controller
@RequestMapping(value={"${openapi.consumerDataStandards.base-path:/cds-au/v1}"})
public class BankingPayeesApiController
extends ApiControllerBase
implements BankingPayeesApi {
    private final BankingPayeeService payeeService;
    private final NativeWebRequest request;

    @Autowired
    public BankingPayeesApiController(NativeWebRequest request, BankingPayeeService payeeService) {
        this.request = request;
        this.payeeService = payeeService;
    }

    public Optional<NativeWebRequest> getRequest() {
        return Optional.ofNullable(this.request);
    }

    public ResponseEntity<ResponseBankingPayeeById> getPayeeDetail(String payeeId, String xCdsClientHeaders, OffsetDateTime xFapiAuthDate, String xFapiCustomerIpAddress, UUID xFapiInteractionId, Integer xMinV, Integer xV) {
        this.validateHeaders(xCdsClientHeaders, xFapiCustomerIpAddress, xMinV, xV);
        HttpHeaders headers = this.generateResponseHeaders(this.request);
        BankingPayeeDetail payeeDetail = this.payeeService.getBankingPayeeDetail(payeeId);
        if (payeeDetail == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        ResponseBankingPayeeById responseBankingPayeeById = new ResponseBankingPayeeById();
        responseBankingPayeeById.setData(payeeDetail);
        responseBankingPayeeById.setLinks(new Links().self(WebUtil.getOriginalUrl((NativeWebRequest)this.request)));
        return new ResponseEntity((Object)responseBankingPayeeById, (MultiValueMap)headers, HttpStatus.OK);
    }

    public ResponseEntity<ResponseBankingPayeeList> listPayees(Integer page, Integer pageSize, BankingPayeesApi.ParamPayeeType type, String xCdsClientHeaders, OffsetDateTime xFapiAuthDate, String xFapiCustomerIpAddress, UUID xFapiInteractionId, Integer xMinV, Integer xV) {
        this.validateHeaders(xCdsClientHeaders, xFapiCustomerIpAddress, xMinV, xV);
        this.validatePageInputs(page, pageSize);
        HttpHeaders headers = this.generateResponseHeaders(this.request);
        Integer actualPage = this.getPagingValue(page, 1);
        Integer actualPageSize = this.getPagingValue(pageSize, 25);
        ResponseBankingPayeeListData listData = new ResponseBankingPayeeListData();
        BankingPayee.Type payeeType = null;
        if (!BankingPayeesApi.ParamPayeeType.ALL.equals((Object)type)) {
            payeeType = BankingPayee.Type.valueOf((String)type.name());
        }
        Page payeePage = this.payeeService.getBankingPayees(payeeType, (Pageable)PageRequest.of((int)(actualPage - 1), (int)actualPageSize));
        listData.setPayees(payeePage.getContent());
        ResponseBankingPayeeList responseBankingPayeeList = new ResponseBankingPayeeList();
        responseBankingPayeeList.setData(listData);
        responseBankingPayeeList.setLinks(this.getLinkData(this.request, payeePage, actualPage, actualPageSize));
        responseBankingPayeeList.setMeta(this.getMetaData(payeePage));
        return new ResponseEntity((Object)responseBankingPayeeList, (MultiValueMap)headers, HttpStatus.OK);
    }
}

