/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.api;

import au.org.consumerdatastandards.holder.api.ApiControllerBase;
import au.org.consumerdatastandards.holder.api.BankingDirectDebitsApi;
import au.org.consumerdatastandards.holder.model.BankingAccount;
import au.org.consumerdatastandards.holder.model.BankingDirectDebit;
import au.org.consumerdatastandards.holder.model.BankingProductCategory;
import au.org.consumerdatastandards.holder.model.ParamAccountOpenStatus;
import au.org.consumerdatastandards.holder.model.ParamProductCategory;
import au.org.consumerdatastandards.holder.model.RequestAccountIds;
import au.org.consumerdatastandards.holder.model.ResponseBankingDirectDebitAuthorisationList;
import au.org.consumerdatastandards.holder.model.ResponseBankingDirectDebitAuthorisationListData;
import au.org.consumerdatastandards.holder.service.BankingDirectDebitService;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.request.NativeWebRequest;

@Validated
@Controller
@RequestMapping(value={"${openapi.consumerDataStandards.base-path:/cds-au/v1}"})
public class BankingDirectDebitsApiController
extends ApiControllerBase
implements BankingDirectDebitsApi {
    private final BankingDirectDebitService directDebitService;
    private final NativeWebRequest request;

    @Autowired
    public BankingDirectDebitsApiController(NativeWebRequest request, BankingDirectDebitService directDebitService) {
        this.request = request;
        this.directDebitService = directDebitService;
    }

    public Optional<NativeWebRequest> getRequest() {
        return Optional.ofNullable(this.request);
    }

    public ResponseEntity<ResponseBankingDirectDebitAuthorisationList> listDirectDebits(String accountId, Integer page, Integer pageSize, String xCdsClientHeaders, OffsetDateTime xFapiAuthDate, String xFapiCustomerIpAddress, UUID xFapiInteractionId, Integer xMinV, Integer xV) {
        this.validateHeaders(xCdsClientHeaders, xFapiCustomerIpAddress, xMinV, xV);
        this.validatePageInputs(page, pageSize);
        HttpHeaders headers = this.generateResponseHeaders(this.request);
        Integer actualPage = this.getPagingValue(page, 1);
        Integer actualPageSize = this.getPagingValue(pageSize, 25);
        ResponseBankingDirectDebitAuthorisationListData listData = new ResponseBankingDirectDebitAuthorisationListData();
        Page directDebitPage = this.directDebitService.getBankingDirectDebits(accountId, (Pageable)PageRequest.of((int)(actualPage - 1), (int)actualPageSize));
        return this.getResponse(headers, actualPage, actualPageSize, listData, directDebitPage);
    }

    public ResponseEntity<ResponseBankingDirectDebitAuthorisationList> listDirectDebitsBulk(Boolean isOwned, ParamAccountOpenStatus paramOpenStatus, ParamProductCategory paramProductCategory, Integer page, Integer pageSize, String xCdsClientHeaders, OffsetDateTime xFapiAuthDate, String xFapiCustomerIpAddress, UUID xFapiInteractionId, Integer xMinV, Integer xV) {
        this.validateHeaders(xCdsClientHeaders, xFapiCustomerIpAddress, xMinV, xV);
        this.validatePageInputs(page, pageSize);
        HttpHeaders headers = this.generateResponseHeaders(this.request);
        Integer actualPage = this.getPagingValue(page, 1);
        Integer actualPageSize = this.getPagingValue(pageSize, 25);
        ResponseBankingDirectDebitAuthorisationListData listData = new ResponseBankingDirectDebitAuthorisationListData();
        BankingAccount.OpenStatus openStatus = null;
        if (paramOpenStatus != null && !ParamAccountOpenStatus.ALL.equals((Object)paramOpenStatus)) {
            openStatus = BankingAccount.OpenStatus.valueOf((String)paramOpenStatus.name());
        }
        BankingProductCategory productCategory = null;
        if (paramProductCategory != null) {
            productCategory = BankingProductCategory.valueOf((String)paramProductCategory.name());
        }
        Page directDebitPage = this.directDebitService.getBankingDirectDebits(isOwned, productCategory, openStatus, (Pageable)PageRequest.of((int)(actualPage - 1), (int)actualPageSize));
        return this.getResponse(headers, actualPage, actualPageSize, listData, directDebitPage);
    }

    public ResponseEntity<ResponseBankingDirectDebitAuthorisationList> listDirectDebitsSpecificAccounts(RequestAccountIds accountIds, Integer page, Integer pageSize, String xCdsClientHeaders, OffsetDateTime xFapiAuthDate, String xFapiCustomerIpAddress, UUID xFapiInteractionId, Integer xMinV, Integer xV) {
        this.validateHeaders(xCdsClientHeaders, xFapiCustomerIpAddress, xMinV, xV);
        this.validatePageInputs(page, pageSize);
        HttpHeaders headers = this.generateResponseHeaders(this.request);
        Integer actualPage = this.getPagingValue(page, 1);
        Integer actualPageSize = this.getPagingValue(pageSize, 25);
        ResponseBankingDirectDebitAuthorisationListData listData = new ResponseBankingDirectDebitAuthorisationListData();
        Page directDebitPage = this.directDebitService.getBankingDirectDebits(accountIds.getData().getAccountIds(), (Pageable)PageRequest.of((int)(actualPage - 1), (int)actualPageSize));
        return this.getResponse(headers, actualPage, actualPageSize, listData, directDebitPage);
    }

    private ResponseEntity<ResponseBankingDirectDebitAuthorisationList> getResponse(HttpHeaders headers, Integer actualPage, Integer actualPageSize, ResponseBankingDirectDebitAuthorisationListData listData, Page<BankingDirectDebit> directDebitPage) {
        listData.setDirectDebitAuthorisations(directDebitPage.getContent());
        ResponseBankingDirectDebitAuthorisationList responseBankingDirectDebitAuthorisationList = new ResponseBankingDirectDebitAuthorisationList();
        responseBankingDirectDebitAuthorisationList.setData(listData);
        responseBankingDirectDebitAuthorisationList.setLinks(this.getLinkData(this.request, directDebitPage, actualPage, actualPageSize));
        responseBankingDirectDebitAuthorisationList.setMeta(this.getMetaData(directDebitPage));
        return new ResponseEntity((Object)responseBankingDirectDebitAuthorisationList, (MultiValueMap)headers, HttpStatus.OK);
    }
}

