/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.api;

import au.org.consumerdatastandards.holder.api.VersionNotSupportedException;
import au.org.consumerdatastandards.holder.model.LinksPaginated;
import au.org.consumerdatastandards.holder.model.MetaPaginated;
import au.org.consumerdatastandards.holder.model.TxMetaPaginated;
import au.org.consumerdatastandards.holder.util.WebUtil;
import java.util.UUID;
import javax.validation.ValidationException;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpHeaders;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.NativeWebRequest;

public class ApiControllerBase {
    private static final String V = "x-v";
    private static final String MIN_V = "x-min-v";
    private static final String CORRELATION_ID = "x-Correlation-Id";
    private static final String FAPI_INTERACTION_ID = "x-fapi-interaction-id";
    private static final String BASE64_PATTERN = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)?$";
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    protected Integer getPagingValue(Integer page, int defaultValue) {
        return page != null && page > 0 ? page : defaultValue;
    }

    protected void validatePageInputs(Integer page, Integer pageSize) {
        if (page != null && page < 1 || pageSize != null && pageSize < 1) {
            throw new ValidationException("Invalid page or page-size");
        }
    }

    protected boolean hasSupportedVersion(Integer xMinV, Integer xV) {
        if (xV == null) {
            return false;
        }
        return !(xMinV != null && this.getCurrentVersion() < xMinV || xMinV == null && this.getCurrentVersion() < xV);
    }

    protected Integer getSupportedVersion(Integer xMinV, Integer xV) {
        this.validateHeaders(xMinV, xV);
        if (xMinV == null) {
            return xV;
        }
        return Math.min(xV, this.getCurrentVersion());
    }

    protected Integer getCurrentVersion() {
        return 1;
    }

    protected HttpHeaders generateResponseHeaders(NativeWebRequest request) {
        String fapiInteractionId;
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.set("content-type", "application/json");
        Integer xMinV = null;
        String minV = request.getHeader(MIN_V);
        if (StringUtils.hasText((String)minV)) {
            xMinV = Integer.parseInt(minV);
        }
        Integer xV = Integer.parseInt(request.getHeader(V));
        responseHeaders.set(V, "" + this.getSupportedVersion(xMinV, xV));
        String correlationId = request.getHeader(CORRELATION_ID);
        if (!StringUtils.isEmpty((Object)correlationId)) {
            responseHeaders.set(CORRELATION_ID, correlationId);
        }
        if (!StringUtils.isEmpty((Object)(fapiInteractionId = request.getHeader(FAPI_INTERACTION_ID)))) {
            responseHeaders.set(FAPI_INTERACTION_ID, fapiInteractionId);
        } else {
            responseHeaders.set(FAPI_INTERACTION_ID, UUID.randomUUID().toString());
        }
        return responseHeaders;
    }

    protected void validateHeaders(Integer xMinV, Integer xV) {
        if (!this.hasSupportedVersion(xMinV, xV)) {
            String message = String.format("Unsupported version requested, minimum version specified is %d, maximum version specified is %d, current version is %d", xMinV, xV, this.getCurrentVersion());
            throw new VersionNotSupportedException(message);
        }
    }

    protected void validateHeaders(String xCdsClientHeaders, String xFapiCustomerIpAddress, Integer xMinV, Integer xV) {
        this.validateHeaders(xMinV, xV);
        if (StringUtils.hasText((String)xFapiCustomerIpAddress)) {
            InetAddressValidator inetAddressValidator = InetAddressValidator.getInstance();
            if (!inetAddressValidator.isValid(xFapiCustomerIpAddress)) {
                throw new ValidationException("request header x-fapi-customer-ip-address is not valid IP address");
            }
            if (StringUtils.isEmpty((Object)xCdsClientHeaders)) {
                throw new ValidationException("request header x-cds-client-headers is not present");
            }
            if (!xCdsClientHeaders.matches(BASE64_PATTERN)) {
                throw new ValidationException("request header x-cds-client-headers is not Base64 encoded");
            }
        }
    }

    protected LinksPaginated getLinkData(NativeWebRequest request, Page page, Integer actualPage, Integer actualPageSize) {
        LinksPaginated linkData = new LinksPaginated();
        linkData.setSelf(WebUtil.getOriginalUrl((NativeWebRequest)request));
        if (page.getTotalPages() == 0) {
            linkData.setFirst(null);
            linkData.setLast(null);
        } else {
            linkData.setFirst(WebUtil.getPaginatedLink((NativeWebRequest)request, (Integer)1, (Integer)actualPageSize));
            linkData.setLast(WebUtil.getPaginatedLink((NativeWebRequest)request, (Integer)page.getTotalPages(), (Integer)actualPageSize));
        }
        if (page.hasPrevious()) {
            linkData.setPrev(WebUtil.getPaginatedLink((NativeWebRequest)request, (Integer)(actualPage - 1), (Integer)actualPageSize));
        }
        if (page.hasNext()) {
            linkData.setNext(WebUtil.getPaginatedLink((NativeWebRequest)request, (Integer)(actualPage + 1), (Integer)actualPageSize));
        }
        return linkData;
    }

    protected MetaPaginated getMetaData(Page page) {
        MetaPaginated metaData = new MetaPaginated();
        metaData.setTotalPages(Integer.valueOf(page.getTotalPages()));
        metaData.setTotalRecords(Integer.valueOf((int)page.getTotalElements()));
        return metaData;
    }

    protected TxMetaPaginated getTxMetaData(Page page, boolean isQueryParamUnsupported) {
        TxMetaPaginated metaData = new TxMetaPaginated();
        metaData.setTotalPages(Integer.valueOf(page.getTotalPages()));
        metaData.setTotalRecords(Integer.valueOf((int)page.getTotalElements()));
        return metaData;
    }
}

