/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.service;

import au.org.consumerdatastandards.holder.model.BankingTransaction;
import au.org.consumerdatastandards.holder.model.BankingTransactionDetail;
import au.org.consumerdatastandards.holder.repository.BankingTransactionDetailRepository;
import au.org.consumerdatastandards.holder.repository.BankingTransactionRepository;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Optional;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BankingTransactionService {
    private final Logger LOGGER = LoggerFactory.getLogger(BankingTransactionService.class);
    private final BankingTransactionRepository bankingTransactionRepository;
    private final BankingTransactionDetailRepository bankingTransactionDetailRepository;

    @Autowired
    public BankingTransactionService(BankingTransactionRepository bankingTransactionRepository, BankingTransactionDetailRepository bankingTransactionDetailRepository) {
        this.bankingTransactionRepository = bankingTransactionRepository;
        this.bankingTransactionDetailRepository = bankingTransactionDetailRepository;
    }

    public BankingTransactionDetail getBankingTransactionDetail(String transactionId) {
        this.LOGGER.debug("Retrieving transaction detail by id {}", (Object)transactionId);
        Optional byId = this.bankingTransactionDetailRepository.findById((Object)transactionId);
        return byId.orElse(null);
    }

    public Page<BankingTransaction> findTransactions(String accountId, BigDecimal maxAmount, BigDecimal minAmount, OffsetDateTime newestTime, OffsetDateTime oldestTime, String text, Pageable pageable) {
        this.LOGGER.debug("Retrieve transactions of account id {} with Paging content specified as {}", (Object)accountId, (Object)pageable);
        return this.bankingTransactionRepository.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(criteriaBuilder.equal((Expression)root.get("accountId"), (Object)accountId));
            if (minAmount != null) {
                predicates.add(criteriaBuilder.ge((Expression)root.get("amount"), (Number)minAmount));
            }
            if (maxAmount != null) {
                predicates.add(criteriaBuilder.le((Expression)root.get("amount"), (Number)maxAmount));
            }
            predicates.add(criteriaBuilder.greaterThanOrEqualTo((Expression)root.get("executionDateTime"), (Comparable)oldestTime));
            predicates.add(criteriaBuilder.lessThanOrEqualTo((Expression)root.get("executionDateTime"), (Comparable)newestTime));
            if (StringUtils.hasText((String)text)) {
                String pattern = "%" + text + "%";
                predicates.add(criteriaBuilder.or((Expression)criteriaBuilder.like((Expression)root.get("reference"), pattern), (Expression)criteriaBuilder.like((Expression)root.get("description"), pattern)));
            }
            return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
        }, pageable);
    }
}

