/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.service;

import au.org.consumerdatastandards.holder.api.VersionNotSupportedException;
import au.org.consumerdatastandards.holder.model.BankingProduct;
import au.org.consumerdatastandards.holder.model.BankingProductDetail;
import au.org.consumerdatastandards.holder.model.BankingProductV1;
import au.org.consumerdatastandards.holder.model.BankingProductV1Detail;
import au.org.consumerdatastandards.holder.model.BankingProductV2;
import au.org.consumerdatastandards.holder.model.BankingProductV2Detail;
import au.org.consumerdatastandards.holder.model.ParamEffective;
import au.org.consumerdatastandards.holder.repository.BankingProductV1DetailRepository;
import au.org.consumerdatastandards.holder.repository.BankingProductV1Repository;
import au.org.consumerdatastandards.holder.repository.BankingProductV2DetailRepository;
import au.org.consumerdatastandards.holder.repository.BankingProductV2Repository;
import au.org.consumerdatastandards.holder.service.BankingProductService;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class BankingProductService {
    private static final Logger LOGGER = LogManager.getLogger(BankingProductService.class);
    private final BankingProductV1Repository productsV1Repository;
    private final BankingProductV2Repository productsV2Repository;
    private final BankingProductV1DetailRepository productDetailV1Repository;
    private final BankingProductV2DetailRepository productDetailV2Repository;

    @Autowired
    public BankingProductService(BankingProductV1Repository productsV1Repository, BankingProductV2Repository productsV2Repository, BankingProductV1DetailRepository productDetailV1Repository, BankingProductV2DetailRepository productDetailV2Repository) {
        this.productsV1Repository = productsV1Repository;
        this.productsV2Repository = productsV2Repository;
        this.productDetailV1Repository = productDetailV1Repository;
        this.productDetailV2Repository = productDetailV2Repository;
    }

    private Page<BankingProductV1> findProductsV1Like(ParamEffective effective, BankingProduct bankingProduct, Pageable pageable) {
        return this.productsV1Repository.findAll((Specification)new BankingProductSpecification(this, effective, bankingProduct), pageable);
    }

    private Page<BankingProductV2> findProductsV2Like(ParamEffective effective, BankingProduct bankingProduct, Pageable pageable) {
        return this.productsV2Repository.findAll((Specification)new BankingProductSpecification(this, effective, bankingProduct), pageable);
    }

    public Page<BankingProduct> findProductsLike(ParamEffective effective, BankingProduct bankingProduct, Pageable pageable, Integer version) {
        LOGGER.debug("Retrieve products matching inputs of effective {}, BankingProduct specified as {} with Paging content specified as {}", (Object)effective, (Object)bankingProduct, (Object)pageable);
        switch (version) {
            case 1: {
                return this.findProductsV1Like(effective, bankingProduct, pageable).map(productV1 -> productV1);
            }
            case 2: {
                return this.findProductsV2Like(effective, bankingProduct, pageable).map(productV2 -> productV2);
            }
        }
        throw new VersionNotSupportedException("Unsupported version " + version);
    }

    private BankingProductV1Detail getProductDetailV1(String productId) {
        Optional byId = this.productDetailV1Repository.findById((Object)productId);
        return byId.orElse(null);
    }

    private BankingProductV2Detail getProductDetailV2(String productId) {
        Optional byId = this.productDetailV2Repository.findById((Object)productId);
        return byId.orElse(null);
    }

    public BankingProductDetail getProductDetail(String productId, Integer version) {
        LOGGER.debug("Retrieving product detail by id {}", (Object)productId);
        switch (version) {
            case 1: {
                return this.getProductDetailV1(productId);
            }
            case 2: {
                return this.getProductDetailV2(productId);
            }
        }
        throw new VersionNotSupportedException("Unsupported version " + version);
    }
}

