/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.model;

import au.org.consumerdatastandards.holder.model.CommonOrganisation;
import au.org.consumerdatastandards.holder.model.CommonPhysicalAddressWithPurpose;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;

@ApiModel
@Entity
@Table(name="CommonOrganisation")
public class CommonOrganisationDetail {
    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid2")
    @JsonIgnore
    private String id;
    private String abn;
    private String acn;
    private String agentFirstName;
    private String agentLastName;
    private String agentRole;
    private String businessName;
    private LocalDate establishmentDate;
    private String industryCode;
    private Boolean isACNCRegistered;
    private OffsetDateTime lastUpdateTime;
    private String legalName;
    private CommonOrganisation.OrganisationType organisationType;
    private String registeredCountry;
    private String shortName;
    @OneToMany
    @JoinTable(name="organisation_physical_addresses", joinColumns={@JoinColumn(name="organisation_id")}, inverseJoinColumns={@JoinColumn(name="physical_address_id")})
    private List<CommonPhysicalAddressWithPurpose> physicalAddresses;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAbn() {
        return this.abn;
    }

    public void setAbn(String abn) {
        this.abn = abn;
    }

    public String getAcn() {
        return this.acn;
    }

    public void setAcn(String acn) {
        this.acn = acn;
    }

    public String getAgentFirstName() {
        return this.agentFirstName;
    }

    public void setAgentFirstName(String agentFirstName) {
        this.agentFirstName = agentFirstName;
    }

    public String getAgentLastName() {
        return this.agentLastName;
    }

    public void setAgentLastName(String agentLastName) {
        this.agentLastName = agentLastName;
    }

    public String getAgentRole() {
        return this.agentRole;
    }

    public void setAgentRole(String agentRole) {
        this.agentRole = agentRole;
    }

    public String getBusinessName() {
        return this.businessName;
    }

    public void setBusinessName(String businessName) {
        this.businessName = businessName;
    }

    public LocalDate getEstablishmentDate() {
        return this.establishmentDate;
    }

    public void setEstablishmentDate(LocalDate establishmentDate) {
        this.establishmentDate = establishmentDate;
    }

    public String getIndustryCode() {
        return this.industryCode;
    }

    public void setIndustryCode(String industryCode) {
        this.industryCode = industryCode;
    }

    public Boolean getIsACNCRegistered() {
        return this.isACNCRegistered;
    }

    public void setIsACNCRegistered(Boolean ACNCRegistered) {
        this.isACNCRegistered = ACNCRegistered;
    }

    public OffsetDateTime getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(OffsetDateTime lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getLegalName() {
        return this.legalName;
    }

    public void setLegalName(String legalName) {
        this.legalName = legalName;
    }

    public CommonOrganisation.OrganisationType getOrganisationType() {
        return this.organisationType;
    }

    public void setOrganisationType(CommonOrganisation.OrganisationType organisationType) {
        this.organisationType = organisationType;
    }

    public String getRegisteredCountry() {
        return this.registeredCountry;
    }

    public void setRegisteredCountry(String registeredCountry) {
        this.registeredCountry = registeredCountry;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public CommonOrganisationDetail abn(String abn) {
        this.abn = abn;
        return this;
    }

    public CommonOrganisationDetail acn(String acn) {
        this.acn = acn;
        return this;
    }

    public CommonOrganisationDetail agentFirstName(String agentFirstName) {
        this.agentFirstName = agentFirstName;
        return this;
    }

    public CommonOrganisationDetail agentLastName(String agentLastName) {
        this.agentLastName = agentLastName;
        return this;
    }

    public CommonOrganisationDetail agentRole(String agentRole) {
        this.agentRole = agentRole;
        return this;
    }

    public CommonOrganisationDetail businessName(String businessName) {
        this.businessName = businessName;
        return this;
    }

    public CommonOrganisationDetail establishmentDate(LocalDate establishmentDate) {
        this.establishmentDate = establishmentDate;
        return this;
    }

    public CommonOrganisationDetail industryCode(String industryCode) {
        this.industryCode = industryCode;
        return this;
    }

    public CommonOrganisationDetail isACNCRegistered(Boolean isACNCRegistered) {
        this.isACNCRegistered = isACNCRegistered;
        return this;
    }

    public CommonOrganisationDetail lastUpdateTime(OffsetDateTime lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
        return this;
    }

    public CommonOrganisationDetail legalName(String legalName) {
        this.legalName = legalName;
        return this;
    }

    public CommonOrganisationDetail organisationType(CommonOrganisation.OrganisationType organisationType) {
        this.organisationType = organisationType;
        return this;
    }

    public CommonOrganisationDetail registeredCountry(String registeredCountry) {
        this.registeredCountry = registeredCountry;
        return this;
    }

    public CommonOrganisationDetail shortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    public CommonOrganisationDetail physicalAddresses(List<CommonPhysicalAddressWithPurpose> physicalAddresses) {
        this.physicalAddresses = physicalAddresses;
        return this;
    }

    public CommonOrganisationDetail addItem(CommonPhysicalAddressWithPurpose physicalAddressesItem) {
        this.physicalAddresses.add(physicalAddressesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Must contain at least one address. One and only one address may have the purpose of REGISTERED. Zero or one, and no more than one, record may have the purpose of MAIL. If zero then the REGISTERED address is to be used for mail")
    public List<CommonPhysicalAddressWithPurpose> getPhysicalAddresses() {
        return this.physicalAddresses;
    }

    public void setPhysicalAddresses(List<CommonPhysicalAddressWithPurpose> physicalAddresses) {
        this.physicalAddresses = physicalAddresses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommonOrganisationDetail commonOrganisationDetail = (CommonOrganisationDetail)o;
        return Objects.equals(this.physicalAddresses, commonOrganisationDetail.physicalAddresses) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(this.physicalAddresses, super.hashCode());
    }

    public String toString() {
        return "class CommonOrganisationDetail {\n   id: " + this.toIndentedString((Object)this.id) + "\n   abn: " + this.toIndentedString((Object)this.getAbn()) + "\n   acn: " + this.toIndentedString((Object)this.getAcn()) + "\n   agentFirstName: " + this.toIndentedString((Object)this.getAgentFirstName()) + "\n   agentLastName: " + this.toIndentedString((Object)this.getAgentLastName()) + "\n   agentRole: " + this.toIndentedString((Object)this.getAgentRole()) + "\n   businessName: " + this.toIndentedString((Object)this.getBusinessName()) + "\n   establishmentDate: " + this.toIndentedString((Object)this.getEstablishmentDate()) + "\n   industryCode: " + this.toIndentedString((Object)this.getIndustryCode()) + "\n   isACNCRegistered: " + this.toIndentedString((Object)this.getIsACNCRegistered()) + "\n   lastUpdateTime: " + this.toIndentedString((Object)this.getLastUpdateTime()) + "\n   legalName: " + this.toIndentedString((Object)this.getLegalName()) + "\n   organisationType: " + this.toIndentedString((Object)this.getOrganisationType()) + "\n   registeredCountry: " + this.toIndentedString((Object)this.getRegisteredCountry()) + "\n   shortName: " + this.toIndentedString((Object)this.getShortName()) + "\n   physicalAddresses: " + this.toIndentedString((Object)this.physicalAddresses) + "\n}";
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

