/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.holder.model;

import au.org.consumerdatastandards.holder.model.BankingTransaction;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import org.springframework.format.annotation.DateTimeFormat;

@ApiModel
@Entity
@Table(name="BankingTransaction")
public class BankingTransaction {
    @Id
    private String transactionId;
    private String accountId;
    private BigDecimal amount;
    private String apcaNumber;
    private String billerCode;
    private String billerName;
    private String crn;
    private String currency;
    private String description;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private OffsetDateTime executionDateTime;
    private Boolean isDetailAvailable;
    private String merchantCategoryCode;
    private String merchantName;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private OffsetDateTime postingDateTime;
    private String reference;
    private Status status;
    private Type type;
    private OffsetDateTime valueDateTime;

    public BankingTransaction accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="ID of the account for which transactions are provided")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public BankingTransaction amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="The value of the transaction. Negative values mean money was outgoing from the account")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public BankingTransaction apcaNumber(String apcaNumber) {
        this.apcaNumber = apcaNumber;
        return this;
    }

    @ApiModelProperty(value="6 Digit APCA number for the initiating institution")
    public String getApcaNumber() {
        return this.apcaNumber;
    }

    public void setApcaNumber(String apcaNumber) {
        this.apcaNumber = apcaNumber;
    }

    public BankingTransaction billerCode(String billerCode) {
        this.billerCode = billerCode;
        return this;
    }

    @ApiModelProperty(value="BPAY Biller Code for the transaction (if available)")
    public String getBillerCode() {
        return this.billerCode;
    }

    public void setBillerCode(String billerCode) {
        this.billerCode = billerCode;
    }

    public BankingTransaction billerName(String billerName) {
        this.billerName = billerName;
        return this;
    }

    @ApiModelProperty(value="Name of the BPAY biller for the transaction (if available)")
    public String getBillerName() {
        return this.billerName;
    }

    public void setBillerName(String billerName) {
        this.billerName = billerName;
    }

    public BankingTransaction crn(String crn) {
        this.crn = crn;
        return this;
    }

    @ApiModelProperty(value="BPAY CRN for the transaction (if available)")
    public String getCrn() {
        return this.crn;
    }

    public void setCrn(String crn) {
        this.crn = crn;
    }

    public BankingTransaction currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(value="The currency for the transaction amount. AUD assumed if not present")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public BankingTransaction description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(required=true, value="The transaction description as applied by the financial institution")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BankingTransaction executionDateTime(OffsetDateTime executionDateTime) {
        this.executionDateTime = executionDateTime;
        return this;
    }

    @ApiModelProperty(value="The time the transaction was executed by the originating customer, if available")
    public OffsetDateTime getExecutionDateTime() {
        return this.executionDateTime;
    }

    public void setExecutionDateTime(OffsetDateTime executionDateTime) {
        this.executionDateTime = executionDateTime;
    }

    public BankingTransaction isDetailAvailable(Boolean isDetailAvailable) {
        this.isDetailAvailable = isDetailAvailable;
        return this;
    }

    @ApiModelProperty(required=true, value="True if extended information is available using the transaction detail end point. False if extended data is not available")
    public Boolean getIsDetailAvailable() {
        return this.isDetailAvailable;
    }

    public void setIsDetailAvailable(Boolean isDetailAvailable) {
        this.isDetailAvailable = isDetailAvailable;
    }

    public BankingTransaction merchantCategoryCode(String merchantCategoryCode) {
        this.merchantCategoryCode = merchantCategoryCode;
        return this;
    }

    @ApiModelProperty(value="The merchant category code (or MCC) for an outgoing payment to a merchant")
    public String getMerchantCategoryCode() {
        return this.merchantCategoryCode;
    }

    public void setMerchantCategoryCode(String merchantCategoryCode) {
        this.merchantCategoryCode = merchantCategoryCode;
    }

    public BankingTransaction merchantName(String merchantName) {
        this.merchantName = merchantName;
        return this;
    }

    @ApiModelProperty(value="Name of the merchant for an outgoing payment to a merchant")
    public String getMerchantName() {
        return this.merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public BankingTransaction postingDateTime(OffsetDateTime postingDateTime) {
        this.postingDateTime = postingDateTime;
        return this;
    }

    @ApiModelProperty(value="The time the transaction was posted. This field is Mandatory if the transaction has status POSTED.  This is the time that appears on a standard statement")
    public OffsetDateTime getPostingDateTime() {
        return this.postingDateTime;
    }

    public void setPostingDateTime(OffsetDateTime postingDateTime) {
        this.postingDateTime = postingDateTime;
    }

    public BankingTransaction reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(required=true, value="The reference for the transaction provided by the originating institution. Empty string if no data provided")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public BankingTransaction status(Status status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true)
    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public BankingTransaction transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @ApiModelProperty(value="A unique ID of the transaction adhering to the standards for ID permanence.  This is mandatory (through hashing if necessary) unless there are specific and justifiable technical reasons why a transaction cannot be uniquely identified for a particular account type")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public BankingTransaction type(Type type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true)
    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public BankingTransaction valueDateTime(OffsetDateTime valueDateTime) {
        this.valueDateTime = valueDateTime;
        return this;
    }

    @ApiModelProperty(value="Date and time at which assets become available to the account owner in case of a credit entry, or cease to be available to the account owner in case of a debit transaction entry")
    public OffsetDateTime getValueDateTime() {
        return this.valueDateTime;
    }

    public void setValueDateTime(OffsetDateTime valueDateTime) {
        this.valueDateTime = valueDateTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankingTransaction bankingTransaction = (BankingTransaction)o;
        return Objects.equals(this.accountId, bankingTransaction.accountId) && Objects.equals(this.amount, bankingTransaction.amount) && Objects.equals(this.apcaNumber, bankingTransaction.apcaNumber) && Objects.equals(this.billerCode, bankingTransaction.billerCode) && Objects.equals(this.billerName, bankingTransaction.billerName) && Objects.equals(this.crn, bankingTransaction.crn) && Objects.equals(this.currency, bankingTransaction.currency) && Objects.equals(this.description, bankingTransaction.description) && Objects.equals(this.executionDateTime, bankingTransaction.executionDateTime) && Objects.equals(this.isDetailAvailable, bankingTransaction.isDetailAvailable) && Objects.equals(this.merchantCategoryCode, bankingTransaction.merchantCategoryCode) && Objects.equals(this.merchantName, bankingTransaction.merchantName) && Objects.equals(this.postingDateTime, bankingTransaction.postingDateTime) && Objects.equals(this.reference, bankingTransaction.reference) && Objects.equals(this.status, bankingTransaction.status) && Objects.equals(this.transactionId, bankingTransaction.transactionId) && Objects.equals(this.type, bankingTransaction.type) && Objects.equals(this.valueDateTime, bankingTransaction.valueDateTime);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.amount, this.apcaNumber, this.billerCode, this.billerName, this.crn, this.currency, this.description, this.executionDateTime, this.isDetailAvailable, this.merchantCategoryCode, this.merchantName, this.postingDateTime, this.reference, this.status, this.transactionId, this.type, this.valueDateTime);
    }

    public String toString() {
        return "class BankingTransaction {\n   accountId: " + this.toIndentedString((Object)this.accountId) + "\n   amount: " + this.toIndentedString((Object)this.amount) + "\n   apcaNumber: " + this.toIndentedString((Object)this.apcaNumber) + "\n   billerCode: " + this.toIndentedString((Object)this.billerCode) + "\n   billerName: " + this.toIndentedString((Object)this.billerName) + "\n   crn: " + this.toIndentedString((Object)this.crn) + "\n   currency: " + this.toIndentedString((Object)this.currency) + "\n   description: " + this.toIndentedString((Object)this.description) + "\n   executionDateTime: " + this.toIndentedString((Object)this.executionDateTime) + "\n   isDetailAvailable: " + this.toIndentedString((Object)this.isDetailAvailable) + "\n   merchantCategoryCode: " + this.toIndentedString((Object)this.merchantCategoryCode) + "\n   merchantName: " + this.toIndentedString((Object)this.merchantName) + "\n   postingDateTime: " + this.toIndentedString((Object)this.postingDateTime) + "\n   reference: " + this.toIndentedString((Object)this.reference) + "\n   status: " + this.toIndentedString((Object)this.status) + "\n   transactionId: " + this.toIndentedString((Object)this.transactionId) + "\n   type: " + this.toIndentedString((Object)this.type) + "\n   valueDateTime: " + this.toIndentedString((Object)this.valueDateTime) + "\n}";
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

